/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.isolevel;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.isolevel.IsoLevelPlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vtk.vtkDataSet;

public class IsoLevelControlUI
extends JDialog
implements ActionListener,
ChangeListener {
    private PipeLineManager pipeLineManager;
    private IsoLevelPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JFormattedTextField minRange;
    private JFormattedTextField maxRange;
    private JCheckBox computeNormal;
    private JTabbedPane levelType;
    private JSlider levelSlider;
    private JFormattedTextField levelValue;
    private JFormattedTextField nbLevel;

    public IsoLevelControlUI(PipeLineManager pipeLineManager, IsoLevelPlugin isoLevelPlugin, Frame frame) {
        super(frame, "Iso lvel configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = isoLevelPlugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), isoLevelPlugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        this.inputDataset.addActionListener(this);
        jPanel.add((Component)this.inputDataset, "Center");
        jPanel.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Range"));
        this.minRange = new JFormattedTextField((Object)"0");
        this.minRange.setValue(new Double(-1.0));
        this.maxRange = new JFormattedTextField((Object)"0");
        this.maxRange.setValue(new Double(1.0));
        jPanel.add(new JLabel("Min"));
        jPanel.add(new JLabel("Max"));
        jPanel.add(this.minRange);
        jPanel.add(this.maxRange);
        this.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.levelValue = new JFormattedTextField((Object)"0");
        this.levelValue.setValue(new Double(0.0));
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0%"));
        hashtable.put(new Integer(50), new JLabel("50%"));
        hashtable.put(new Integer(100), new JLabel("100%"));
        this.levelSlider = new JSlider(0, 100, 50);
        this.levelSlider.setMinorTickSpacing(1);
        this.levelSlider.setMajorTickSpacing(10);
        this.levelSlider.setLabelTable(hashtable);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.setPaintLabels(true);
        this.levelSlider.addChangeListener(this);
        this.levelSlider.setToolTipText("Move inside the range");
        jPanel2.add((Component)this.levelValue, "North");
        jPanel2.add((Component)this.levelSlider, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        this.nbLevel = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.nbLevel.setValue(new Integer(10));
        jPanel.add(new JLabel("Nb levels : "));
        jPanel.add(this.nbLevel);
        jPanel.add(Box.createVerticalGlue());
        jPanel3.add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        this.levelType = new JTabbedPane();
        this.levelType.addTab("Simple iso-level", jPanel2);
        this.levelType.addTab("Multi iso-level", jPanel3);
        this.getContentPane().add(this.levelType);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel();
        this.computeNormal = new JCheckBox("Computes normals");
        JButton jButton = new JButton("Update");
        jButton.setActionCommand("UPDATE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(this.computeNormal);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add(jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(300, dimension.height);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        double[] dArray;
        String string = actionEvent.getActionCommand();
        int n = 0;
        if (string.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                n = this.levelType.getSelectedIndex();
                this.plugin.setControls(this.computeNormal.isSelected(), false);
                int n2 = ((Number)this.nbLevel.getValue()).intValue();
                double d = ((Number)this.minRange.getValue()).doubleValue();
                double d2 = ((Number)this.maxRange.getValue()).doubleValue();
                this.plugin.updateIsoLevel((vtkDataSet)((VtkObject)this.datasetModel.getSelectedItem()).getVtkObject(), this.updateLevelValue(), n2, n, d, d2);
                this.pipeLineManager.validateViewAndGo();
            }
        } else if (string.equals("CANCEL")) {
            this.dispose();
        } else if (this.datasetModel.getSelectedItem() != null && (dArray = ((vtkDataSet)((VtkObject)this.datasetModel.getSelectedItem()).getVtkObject()).GetScalarRange()) != null) {
            this.minRange.setValue(new Double(dArray[0]));
            this.maxRange.setValue(new Double(dArray[1]));
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        double d = this.updateLevelValue();
        if (this.inputDataset.getSelectedItem() != null) {
            int n = ((Number)this.nbLevel.getValue()).intValue();
            double d2 = ((Number)this.minRange.getValue()).doubleValue();
            double d3 = ((Number)this.maxRange.getValue()).doubleValue();
            this.plugin.updateIsoLevel((vtkDataSet)((VtkObject)this.inputDataset.getSelectedItem()).getVtkObject(), d, 1, 0, d2, d3);
            this.pipeLineManager.validateViewAndGo();
        }
    }

    private double updateLevelValue() {
        double d = this.levelSlider.getValue();
        double d2 = ((Number)this.minRange.getValue()).doubleValue();
        double d3 = ((Number)this.maxRange.getValue()).doubleValue();
        double d4 = (d3 - d2) / 100.0;
        double d5 = d * d4 + d2;
        this.levelValue.setValue(new Double(d5));
        return d5;
    }
}

