/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.isolevel;

import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.isolevel.IsoLevelControlUI;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataSet;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;
import vtk.vtkPolyDataNormals;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;

public class IsoLevelPlugin
implements CassandraPlugin,
RemoveListener {
    private String name = "Iso level";
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private IsoLevelControlUI controlUI;
    private int nbUpdate = 0;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkPlane plane;
    private vtkCutter planeCut;
    private vtkPolyDataMapper isoLevelMapper;
    private vtkActor isoLevelActor;
    private vtkContourFilter contour;
    private vtkPolyDataNormals normals;
    private VtkObject actor;
    private VtkObject mapper;
    private VtkObject dataset;
    private VtkObject datasetN;
    private VtkObject filter;
    private Filter filerImpl = new FilterImpl();
    private vtkAssembly assembly;
    private boolean normalFlag;

    public IsoLevelPlugin() {
    }

    public IsoLevelPlugin(PipeLineManager pipeLineManager, PluginManager pluginManager, Frame frame) {
        this();
        this.pipelineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.controlUI = new IsoLevelControlUI(pipeLineManager, this, frame);
        this.contextualMenu = new JPopupMenu("Iso level menu");
        JMenuItem jMenuItem = new JMenuItem("Show control");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IsoLevelPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(jMenuItem);
        this.contextualMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Remove");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                IsoLevelPlugin.this.remove();
            }
        });
        this.contextualMenu.add(jMenuItem2);
        this.contour = new vtkContourFilter();
        this.contour.SetValue(0, 0.1);
        this.normals = new vtkPolyDataNormals();
        this.normals.SetInput(this.contour.GetOutput());
        this.normals.SetFeatureAngle(45.0);
        this.isoLevelMapper = new vtkPolyDataMapper();
        this.isoLevelMapper.ScalarVisibilityOn();
        this.isoLevelMapper.ColorByArrayComponent("Magnitude", 0);
        this.isoLevelActor = new vtkActor();
        this.isoLevelActor.SetMapper((vtkMapper)this.isoLevelMapper);
        this.filerImpl.getOutputDataSet().add(this.contour.GetOutput());
        this.filerImpl.getOutputDataSet().add(this.normals.GetOutput());
        this.filerImpl.addRemoveListener((RemoveListener)this);
        this.lookupTable = new vtkLookupTable();
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.isoLevelMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        vtkScalarBarActor vtkScalarBarActor2 = new vtkScalarBarActor();
        vtkScalarBarActor2.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.actor = pipeLineManager.addActor((Object)this.isoLevelActor, "IsoLevel");
        this.mapper = pipeLineManager.addMapper((Object)this.isoLevelMapper, "IsoLevel");
        this.dataset = pipeLineManager.addDataSet((Object)this.contour.GetOutput(), "Contour");
        this.datasetN = pipeLineManager.addDataSet((Object)this.normals.GetOutput(), "Normal");
        this.filter = pipeLineManager.addFilter(this.filerImpl, "IsoLevel");
        pipeLineManager.addLookupTable(this.lookupTable, "IsoLevel");
        pipeLineManager.setActorVisible(pipeLineManager.addScalarBar(vtkScalarBarActor2, "IsoLevel"), true);
        this.filter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.actor.setValide(false);
    }

    public void updateIsoLevel(vtkDataSet vtkDataSet2, double d, int n, int n2, double d2, double d3) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.filerImpl.getInputDataSet().clear();
        this.filerImpl.getInputDataSet().add(vtkDataSet2);
        this.pipelineManager.notifyConnectivityChange(this.dataset);
        this.actor.setValide(true);
        this.contour.SetInput(vtkDataSet2);
        this.setNormal(this.normalFlag);
        this.contour.ComputeScalarsOn();
        this.isoLevelMapper.ColorByArrayComponent("Magnitude", 0);
        if (n2 == 0) {
            this.contour.SetNumberOfContours(1);
            this.contour.SetValue(0, d);
        } else {
            this.contour.GenerateValues(n, d2, d3);
        }
        if ((this.lastDataSet == null || !this.lastDataSet.equals(vtkDataSet2)) && this.isoLevelMapper.GetLookupTable().equals(this.lookupTable)) {
            this.isoLevelMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.nbUpdate++ == 0 && this.pipelineManager.getActorList().getData().contains(this.actor)) {
            this.pipelineManager.setActorVisible(this.actor, true);
        }
        this.pipelineManager.notifyConnectivityChange(this.dataset);
    }

    public void setControls(boolean bl, boolean bl2) {
        this.normalFlag = bl;
    }

    private void setNormal(boolean bl) {
        if (bl) {
            if (this.normals.GetOutput() != null) {
                this.isoLevelMapper.SetInput(this.normals.GetOutput());
            } else {
                System.out.println("No data to generate normals for!");
                this.isoLevelMapper.SetInput(this.contour.GetOutput());
            }
        } else {
            this.isoLevelMapper.SetInput(this.contour.GetOutput());
        }
    }

    public String getName() {
        return this.name;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.actor);
        this.pipelineManager.removeVtkObject(this.mapper);
        this.pipelineManager.removeVtkObject(this.dataset);
        this.pipelineManager.removeVtkObject(this.filter);
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public String toString() {
        return this.getName();
    }

    public VtkObject getOutputDataSet() {
        return this.dataset;
    }

    public VtkObject getActor() {
        return this.actor;
    }
}

