/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import com.artenum.cassandra.plugin.PluginManager;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;

public class CassandraTreeModel
extends DefaultTreeModel
implements ListDataListener {
    private PipeLineManager pipelineManager;
    private PluginManager pluginModel;
    private VtkObjectListModel actorModel;
    private VtkObjectListModel mapperModel;
    private VtkObjectListModel datasetModel;
    private VtkObjectListModel lookupTableModel;
    private VtkObjectListModel scalarBarModel;
    private VtkObjectListModel txtActorModel;
    private DefaultMutableTreeNode actorParentNode;
    private DefaultMutableTreeNode mapperParentNode;
    private DefaultMutableTreeNode datasetParentNode;
    private DefaultMutableTreeNode lookupTableParentNode;
    private DefaultMutableTreeNode scalarParentNode;
    private DefaultMutableTreeNode txtActorParentNode;
    private DefaultMutableTreeNode pluginParentNode;
    private DefaultMutableTreeNode root;

    public CassandraTreeModel(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        super(new DefaultMutableTreeNode("Vtk components"));
        this.pipelineManager = pipeLineManager;
        this.actorModel = pipeLineManager.getActorList();
        this.mapperModel = pipeLineManager.getMapperList();
        this.datasetModel = pipeLineManager.getDataSetList();
        this.txtActorModel = pipeLineManager.getTextActorList();
        this.scalarBarModel = pipeLineManager.getScalarBarList();
        this.lookupTableModel = pipeLineManager.getLookupTableList();
        this.pluginModel = pluginManager;
        this.datasetModel.addListDataListener(this);
        this.mapperModel.addListDataListener(this);
        this.actorModel.addListDataListener(this);
        this.lookupTableModel.addListDataListener(this);
        this.txtActorModel.addListDataListener(this);
        this.scalarBarModel.addListDataListener(this);
        this.pluginModel.addListDataListener(this);
        this.root = (DefaultMutableTreeNode)this.getRoot();
        this.actorParentNode = new DefaultMutableTreeNode("Actors");
        this.mapperParentNode = new DefaultMutableTreeNode("Mappers");
        this.datasetParentNode = new DefaultMutableTreeNode("Dataset");
        this.pluginParentNode = new DefaultMutableTreeNode("Plugins");
        this.scalarParentNode = new DefaultMutableTreeNode("ScalarBar");
        this.txtActorParentNode = new DefaultMutableTreeNode("Text");
        this.lookupTableParentNode = new DefaultMutableTreeNode("Lookup Table");
        this.insertNodeInto(this.actorParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.scalarParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.txtActorParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.mapperParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.lookupTableParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.datasetParentNode, this.root, this.root.getChildCount());
        this.insertNodeInto(this.pluginParentNode, this.root, this.root.getChildCount());
        this.reload();
    }

    public void reload() {
        this.actorParentNode.removeAllChildren();
        this.mapperParentNode.removeAllChildren();
        this.datasetParentNode.removeAllChildren();
        this.pluginParentNode.removeAllChildren();
        this.scalarParentNode.removeAllChildren();
        this.txtActorParentNode.removeAllChildren();
        this.lookupTableParentNode.removeAllChildren();
        Iterator iterator = this.actorModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.actorParentNode, this.actorParentNode.getChildCount());
        }
        iterator = this.mapperModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.mapperParentNode, this.mapperParentNode.getChildCount());
        }
        iterator = this.datasetModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.datasetParentNode, this.datasetParentNode.getChildCount());
        }
        iterator = this.pluginModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.pluginParentNode, this.pluginParentNode.getChildCount());
        }
        iterator = this.txtActorModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.txtActorParentNode, this.txtActorParentNode.getChildCount());
        }
        iterator = this.scalarBarModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.scalarParentNode, this.scalarParentNode.getChildCount());
        }
        iterator = this.lookupTableModel.getData().iterator();
        while (iterator.hasNext()) {
            this.insertNodeInto(new DefaultMutableTreeNode(iterator.next()), this.lookupTableParentNode, this.lookupTableParentNode.getChildCount());
        }
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        this.reload();
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.actorModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.actorModel.getLastVtkObject()), this.actorParentNode, this.actorParentNode.getChildCount());
        }
        if (listDataEvent.getSource().equals(this.mapperModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.mapperModel.getLastVtkObject()), this.mapperParentNode, this.mapperParentNode.getChildCount());
        }
        if (listDataEvent.getSource().equals(this.datasetModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.datasetModel.getLastVtkObject()), this.datasetParentNode, this.datasetParentNode.getChildCount());
        }
        if (listDataEvent.getSource().equals(this.pluginModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.pluginModel.getLastPlugin()), this.pluginParentNode, this.pluginParentNode.getChildCount());
        }
        if (listDataEvent.getSource().equals(this.txtActorModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.txtActorModel.getLastVtkObject()), this.txtActorParentNode, this.txtActorParentNode.getChildCount());
        }
        if (listDataEvent.getSource().equals(this.scalarBarModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.scalarBarModel.getLastVtkObject()), this.scalarParentNode, this.scalarParentNode.getChildCount());
        }
        if (listDataEvent.getSource().equals(this.lookupTableModel)) {
            this.insertNodeInto(new DefaultMutableTreeNode(this.lookupTableModel.getLastVtkObject()), this.lookupTableParentNode, this.lookupTableParentNode.getChildCount());
        }
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        if (listDataEvent.getSource().equals(this.actorModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.actorParentNode.getChildAt(listDataEvent.getIndex0()));
        }
        if (listDataEvent.getSource().equals(this.mapperModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.mapperParentNode.getChildAt(listDataEvent.getIndex0()));
        }
        if (listDataEvent.getSource().equals(this.datasetModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.datasetParentNode.getChildAt(listDataEvent.getIndex0()));
        }
        if (listDataEvent.getSource().equals(this.pluginModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.pluginParentNode.getChildAt(listDataEvent.getIndex0()));
        }
        if (listDataEvent.getSource().equals(this.txtActorModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.txtActorParentNode.getChildAt(listDataEvent.getIndex0()));
        }
        if (listDataEvent.getSource().equals(this.scalarBarModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.scalarParentNode.getChildAt(listDataEvent.getIndex0()));
        }
        if (listDataEvent.getSource().equals(this.lookupTableModel)) {
            this.removeNodeFromParent((MutableTreeNode)this.lookupTableParentNode.getChildAt(listDataEvent.getIndex0()));
        }
    }
}

