/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui;

import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.popup.ActorPopupMenu;
import com.artenum.cassandra.ui.popup.DataSetPopupMenu;
import com.artenum.cassandra.ui.popup.LookupTablePopupMenu;
import com.artenum.cassandra.ui.popup.MapperPopupMenu;
import com.artenum.cassandra.ui.popup.ScalarBarPopupMenu;
import com.artenum.cassandra.ui.popup.TxtActorPopupMenu;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import java.awt.Component;
import javax.swing.JPopupMenu;

public class VtkObjectPopupMenuDipatcher {
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private VtkObject vtkObject;
    private JPopupMenu currentMenu;
    private DataSetPopupMenu dataSetMenu;
    private LookupTablePopupMenu lookupTableMenu;
    private ActorPopupMenu actorMenu;
    private TxtActorPopupMenu txtActorMenu;
    private ScalarBarPopupMenu scalarBarMenu;
    private MapperPopupMenu mapperMenu;

    public VtkObjectPopupMenuDipatcher(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        CascadeRemoveManager cascadeRemoveManager = new CascadeRemoveManager(pipeLineManager);
        this.dataSetMenu = new DataSetPopupMenu(pipeLineManager, cascadeRemoveManager);
        this.lookupTableMenu = new LookupTablePopupMenu(pipeLineManager, cascadeRemoveManager);
        this.actorMenu = new ActorPopupMenu(pipeLineManager, cascadeRemoveManager);
        this.txtActorMenu = new TxtActorPopupMenu(pipeLineManager, cascadeRemoveManager);
        this.scalarBarMenu = new ScalarBarPopupMenu(pipeLineManager, cascadeRemoveManager);
        this.mapperMenu = new MapperPopupMenu(pipeLineManager, cascadeRemoveManager);
    }

    private JPopupMenu getPopup() {
        JPopupMenu jPopupMenu = (JPopupMenu)this.vtkObject.getMetaData().get("POPUP_MENU");
        if (jPopupMenu != null) {
            return jPopupMenu;
        }
        switch (this.vtkObject.getType()) {
            case 1: {
                return this.actorMenu;
            }
            case 6: {
                return this.scalarBarMenu;
            }
            case 7: {
                return this.txtActorMenu;
            }
            case 2: {
                return this.mapperMenu;
            }
            case 3: {
                return this.dataSetMenu;
            }
            case 5: {
                return this.lookupTableMenu;
            }
        }
        return null;
    }

    public void showPopupMenu(Component component, int n, int n2, VtkObject vtkObject) {
        this.vtkObject = vtkObject;
        this.currentMenu = this.getPopup();
        if (this.currentMenu != null) {
            if (this.currentMenu instanceof VtkObjectPopupMenu) {
                ((VtkObjectPopupMenu)((Object)this.currentMenu)).setCurrentVtkOject(vtkObject);
            }
            this.currentMenu.show(component, n, n2);
        }
    }
}

