/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import vtk.vtkActor;
import vtk.vtkActor2D;

public class ActorPopupMenu
extends JPopupMenu
implements ActionListener,
ChangeListener,
VtkObjectPopupMenu {
    public static final String ACTOR_SHOW = "actor.show";
    public static final String ACTOR_COLOR = "actor.color";
    public static final String ACTOR_REMOVE = "actor.remove";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private VtkObject currentVtkObject;
    private JCheckBoxMenuItem viewActor;
    private JSlider actorOpacity;
    private JMenuItem actorColor;
    private RenameVtkObject actorRename;
    private JMenuItem actorRemove;

    public ActorPopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.viewActor = new JCheckBoxMenuItem("Visible");
        this.viewActor.setActionCommand(ACTOR_SHOW);
        this.viewActor.addActionListener(this);
        this.actorColor = new JMenuItem("Actor color");
        this.actorColor.setActionCommand(ACTOR_COLOR);
        this.actorColor.addActionListener(this);
        this.actorOpacity = new JSlider(0, 50, 50);
        this.actorOpacity.addChangeListener(this);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel("0%"));
        hashtable.put(new Integer(50), new JLabel("100%"));
        hashtable.put(new Integer(25), new JLabel("50%"));
        this.actorOpacity.setMinorTickSpacing(1);
        this.actorOpacity.setMajorTickSpacing(5);
        this.actorOpacity.setLabelTable(hashtable);
        this.actorOpacity.setPaintLabels(true);
        this.actorOpacity.setPaintLabels(true);
        this.actorRename = new RenameVtkObject("Rename", "Rename actor", null);
        this.actorRemove = new JMenuItem("Remove");
        this.actorRemove.setActionCommand(ACTOR_REMOVE);
        this.actorRemove.addActionListener(this);
        this.add(this.viewActor);
        this.add(this.actorOpacity);
        this.addSeparator();
        this.add(this.actorColor);
        this.add(this.actorRename);
        this.addSeparator();
        this.add(this.actorRemove);
    }

    public void setCurrentVtkOject(VtkObject vtkObject) {
        this.currentVtkObject = vtkObject;
        this.actorRename.setVtkObject(vtkObject);
        this.actorColor.setEnabled(vtkObject.getVtkObject() instanceof vtkActor);
        if (vtkObject.getVtkObject() instanceof vtkActor) {
            this.actorOpacity.setValue((int)(((vtkActor)vtkObject.getVtkObject()).GetProperty().GetOpacity() * 50.0));
        }
        if (vtkObject.getVtkObject() instanceof vtkActor2D) {
            this.actorOpacity.setValue((int)(((vtkActor2D)vtkObject.getVtkObject()).GetProperty().GetOpacity() * 50.0));
        }
        if (vtkObject.getMetaData().get("ACTOR_VISIBLE") == null) {
            this.viewActor.setSelected(false);
        } else {
            this.viewActor.setSelected(((String)vtkObject.getMetaData().get("ACTOR_VISIBLE")).equals("true"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTOR_SHOW)) {
            this.pipeLineManager.setActorVisible(this.currentVtkObject, this.viewActor.isSelected());
        } else if (string.equals(ACTOR_COLOR)) {
            Color color = JColorChooser.showDialog(this, "Actor color", Color.BLACK);
            if (color != null) {
                double d = (float)color.getRed() / 255.0f;
                double d2 = (float)color.getGreen() / 255.0f;
                double d3 = (float)color.getBlue() / 255.0f;
                if (this.currentVtkObject.getVtkObject() instanceof vtkActor) {
                    ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetColor(d, d2, d3);
                }
                ((vtkActor)this.currentVtkObject.getVtkObject()).ApplyProperties();
            }
        } else if (string.equals(ACTOR_REMOVE)) {
            this.cascadeRemoveManager.removeActor(this.currentVtkObject);
        }
        this.pipeLineManager.validateViewAndGo();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.currentVtkObject.getVtkObject() instanceof vtkActor) {
            ((vtkActor)this.currentVtkObject.getVtkObject()).GetProperty().SetOpacity((double)this.actorOpacity.getValue() / 50.0);
        } else if (this.currentVtkObject.getVtkObject() instanceof vtkActor2D) {
            ((vtkActor2D)this.currentVtkObject.getVtkObject()).GetProperty().SetOpacity((double)this.actorOpacity.getValue() / 50.0);
        }
        this.pipeLineManager.validateViewAndGo();
    }

    public JMenuItem getActorColorMenuItem() {
        return this.actorColor;
    }

    public JSlider getActorOpacityMenuItem() {
        return this.actorOpacity;
    }

    public JMenuItem getActorRemoveMenuItem() {
        return this.actorRemove;
    }

    public JMenuItem getActorRenameMenuItem() {
        return this.actorRename;
    }

    public JCheckBoxMenuItem getActorVisibleMenuItem() {
        return this.viewActor;
    }
}

