/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.popup;

import com.artenum.cassandra.action.menu.RenameVtkObject;
import com.artenum.cassandra.pipeline.CascadeRemoveManager;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.ui.dialog.LookUpTableControlDialog;
import com.artenum.cassandra.ui.popup.VtkObjectPopupMenu;
import com.artenum.cassandra.util.CassandraToolBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkScalarsToColors;

public class LookupTablePopupMenu
extends JPopupMenu
implements ActionListener,
VtkObjectPopupMenu {
    public static final String LOOKUP_TABLE_SHOW_CONTROL = "lookup.table.control";
    public static final String LOOKUP_TABLE_REMOVE = "lookup.table.remove";
    private PipeLineManager pipeLineManager;
    private CascadeRemoveManager cascadeRemoveManager;
    private VtkObject currentVtkObject;
    private Hashtable controlDialogTable;
    private JMenuItem showControl;
    private RenameVtkObject lookupTableRename;
    private JMenuItem lookupTableRemove;
    private JMenu mapperList;

    public LookupTablePopupMenu(PipeLineManager pipeLineManager, CascadeRemoveManager cascadeRemoveManager) {
        this.pipeLineManager = pipeLineManager;
        this.cascadeRemoveManager = cascadeRemoveManager;
        this.controlDialogTable = new Hashtable();
        this.showControl = new JMenuItem("Show control");
        this.showControl.setActionCommand(LOOKUP_TABLE_SHOW_CONTROL);
        this.showControl.addActionListener(this);
        this.add(this.showControl);
        this.mapperList = new JMenu("Link to mapper...");
        this.add(this.mapperList);
        this.lookupTableRename = new RenameVtkObject("Rename", "Rename lookup table", null);
        this.add(this.lookupTableRename);
        this.addSeparator();
        this.lookupTableRemove = new JMenuItem("Remove");
        this.lookupTableRemove.setActionCommand(LOOKUP_TABLE_REMOVE);
        this.lookupTableRemove.addActionListener(this);
        this.add(this.lookupTableRemove);
    }

    private void updateMapperList() {
        VtkObject vtkObject = null;
        this.mapperList.removeAll();
        JMenuItem jMenuItem = null;
        Iterator iterator = this.pipeLineManager.getMapperList().getData().iterator();
        while (iterator.hasNext()) {
            vtkObject = (VtkObject)iterator.next();
            jMenuItem = new JMenuItem(vtkObject.getName());
            jMenuItem.addActionListener(new LookupTableSetter((vtkMapper)vtkObject.getVtkObject()));
            this.mapperList.add(jMenuItem);
        }
    }

    public void setCurrentVtkOject(VtkObject vtkObject) {
        this.currentVtkObject = vtkObject;
        this.lookupTableRename.setVtkObject(vtkObject);
        this.updateMapperList();
        if (this.controlDialogTable.get(vtkObject) != null) {
            ((LookUpTableControlDialog)this.controlDialogTable.get(vtkObject)).setLookupTable(vtkObject);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(LOOKUP_TABLE_REMOVE)) {
            this.cascadeRemoveManager.removeLookupTable(this.currentVtkObject);
        } else if (string.equals(LOOKUP_TABLE_SHOW_CONTROL)) {
            ((LookUpTableControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setVisible(true);
        }
    }

    public void show(Component component, int n, int n2) {
        if ((LookUpTableControlDialog)this.controlDialogTable.get(this.currentVtkObject) == null) {
            this.controlDialogTable.put(this.currentVtkObject, new LookUpTableControlDialog(CassandraToolBox.getParentFrame(component), this.pipeLineManager));
            ((LookUpTableControlDialog)this.controlDialogTable.get(this.currentVtkObject)).setLookupTable(this.currentVtkObject);
        }
        this.updateMapperList();
        super.show(component, n, n2);
    }

    private class LookupTableSetter
    implements ActionListener {
        private vtkMapper mapper;

        public LookupTableSetter(vtkMapper vtkMapper2) {
            this.mapper = vtkMapper2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.mapper.SetLookupTable((vtkScalarsToColors)((vtkLookupTable)LookupTablePopupMenu.this.currentVtkObject.getVtkObject()));
            CassandraToolBox.updateMapper(LookupTablePopupMenu.this.pipeLineManager, (vtkLookupTable)LookupTablePopupMenu.this.currentVtkObject.getVtkObject());
            LookupTablePopupMenu.this.pipeLineManager.notifyConnectivityChange(LookupTablePopupMenu.this.currentVtkObject);
            LookupTablePopupMenu.this.pipeLineManager.validateViewAndGo();
        }
    }
}

