/*
 * Decompiled with CFR 0.152.
 */
package vtk;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.SwingUtilities;
import vtk.vtkActor;
import vtk.vtkActorCollection;
import vtk.vtkCamera;
import vtk.vtkLight;
import vtk.vtkPropPicker;
import vtk.vtkRenderWindow;
import vtk.vtkRenderer;
import vtk.vtkTIFFWriter;
import vtk.vtkWindow;
import vtk.vtkWindowToImageFilter;

public class vtkPanel
extends Canvas
implements MouseListener,
MouseMotionListener,
KeyListener {
    protected vtkRenderWindow rw = new vtkRenderWindow();
    protected vtkRenderer ren = new vtkRenderer();
    protected vtkCamera cam = null;
    protected vtkLight lgt = new vtkLight();
    protected int lastX;
    protected int lastY;
    protected int windowset = 0;
    protected int lightingset = 0;
    protected int LightFollowCamera = 1;
    protected int InteractionMode = 1;
    protected boolean rendering = false;
    protected WindowObservable windowSetObservable = new WindowObservable();

    protected native int RenderCreate(vtkRenderWindow var1);

    protected native int Lock();

    protected native int UnLock();

    public vtkPanel() {
        this.rw.AddRenderer(this.ren);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        super.setSize(200, 200);
        this.rw.SetSize(200, 200);
    }

    public void Report() {
        Runnable runnable = new Runnable(){

            public void run() {
                vtkPanel.this.Lock();
                System.out.println("direct rendering = " + (vtkPanel.this.rw.IsDirect() == 1));
                System.out.println("opengl supported = " + (vtkPanel.this.rw.SupportsOpenGL() == 1));
                System.out.println("report = " + vtkPanel.this.rw.ReportCapabilities());
                vtkPanel.this.UnLock();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public vtkRenderer GetRenderer() {
        return this.ren;
    }

    public vtkRenderWindow GetRenderWindow() {
        return this.rw;
    }

    public void addWindowSetObserver(Observer observer) {
        this.windowSetObservable.addObserver(observer);
    }

    public void removeWindowSetObserver(Observer observer) {
        this.windowSetObservable.deleteObserver(observer);
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.windowset == 1) {
            this.Lock();
            this.rw.SetSize(n, n2);
            this.UnLock();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.windowset = 0;
        this.rw.SetForceMakeCurrent();
        this.rendering = false;
    }

    public void removeNotify() {
        this.rendering = true;
        super.removeNotify();
    }

    public synchronized void Render() {
        if (!this.rendering) {
            this.rendering = true;
            if (this.ren.VisibleActorCount() == 0) {
                this.rendering = false;
                return;
            }
            if (this.rw != null) {
                if (this.windowset == 0) {
                    this.cam = this.ren.GetActiveCamera();
                    if (this.lightingset == 0) {
                        this.ren.AddLight(this.lgt);
                        this.lgt.SetPosition(this.cam.GetPosition());
                        this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
                        this.lightingset = 1;
                    }
                    this.RenderCreate(this.rw);
                    this.windowset = 1;
                    this.windowSetObservable.notifyObservers();
                }
                this.Lock();
                this.rw.Render();
                this.UnLock();
                this.rendering = false;
            }
        }
    }

    public boolean isWindowSet() {
        return this.windowset == 1;
    }

    public void paint(Graphics graphics) {
        this.Render();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void LightFollowCameraOn() {
        this.LightFollowCamera = 1;
    }

    public void LightFollowCameraOff() {
        this.LightFollowCamera = 0;
    }

    public void InteractionModeRotate() {
        this.InteractionMode = 1;
    }

    public void InteractionModeTranslate() {
        this.InteractionMode = 2;
    }

    public void InteractionModeZoom() {
        this.InteractionMode = 3;
    }

    public void UpdateLight() {
        this.lgt.SetPosition(this.cam.GetPosition());
        this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
    }

    public void resetCameraClippingRange() {
        this.Lock();
        this.ren.ResetCameraClippingRange();
        this.UnLock();
    }

    public void resetCamera() {
        this.Lock();
        this.ren.ResetCamera();
        this.UnLock();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        this.rw.SetDesiredUpdateRate(5.0);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        if (mouseEvent.getModifiers() == 8 || mouseEvent.getModifiers() == 17) {
            this.InteractionModeTranslate();
        } else if (mouseEvent.getModifiers() == 4) {
            this.InteractionModeZoom();
        } else {
            this.InteractionModeRotate();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.rw.SetDesiredUpdateRate(0.01);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.requestFocus();
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        if (this.InteractionMode == 1) {
            this.cam.Azimuth((double)(this.lastX - n));
            this.cam.Elevation((double)(n2 - this.lastY));
            this.cam.OrthogonalizeViewUp();
            this.resetCameraClippingRange();
            if (this.LightFollowCamera == 1) {
                this.lgt.SetPosition(this.cam.GetPosition());
                this.lgt.SetFocalPoint(this.cam.GetFocalPoint());
            }
        }
        if (this.InteractionMode == 2) {
            double[] dArray = new double[3];
            double[] dArray2 = this.cam.GetFocalPoint();
            double[] dArray3 = this.cam.GetPosition();
            this.ren.SetWorldPoint(dArray2[0], dArray2[1], dArray2[2], 1.0);
            this.ren.WorldToDisplay();
            double d = this.ren.GetDisplayPoint()[2];
            dArray[0] = (double)this.rw.GetSize()[0] / 2.0 + (double)(n - this.lastX);
            dArray[1] = (double)this.rw.GetSize()[1] / 2.0 - (double)(n2 - this.lastY);
            dArray[2] = d;
            this.ren.SetDisplayPoint(dArray);
            this.ren.DisplayToWorld();
            double[] dArray4 = this.ren.GetWorldPoint();
            if (dArray4[3] != 0.0) {
                dArray4[0] = dArray4[0] / dArray4[3];
                dArray4[1] = dArray4[1] / dArray4[3];
                dArray4[2] = dArray4[2] / dArray4[3];
            }
            this.cam.SetFocalPoint((dArray2[0] - dArray4[0]) / 2.0 + dArray2[0], (dArray2[1] - dArray4[1]) / 2.0 + dArray2[1], (dArray2[2] - dArray4[2]) / 2.0 + dArray2[2]);
            this.cam.SetPosition((dArray2[0] - dArray4[0]) / 2.0 + dArray3[0], (dArray2[1] - dArray4[1]) / 2.0 + dArray3[1], (dArray2[2] - dArray4[2]) / 2.0 + dArray3[2]);
            this.resetCameraClippingRange();
        }
        if (this.InteractionMode == 3) {
            double d = Math.pow(1.02, n2 - this.lastY);
            if (this.cam.GetParallelProjection() == 1) {
                this.cam.SetParallelScale(this.cam.GetParallelScale() / d);
            } else {
                this.cam.Dolly(d);
                this.resetCameraClippingRange();
            }
        }
        this.lastX = n;
        this.lastY = n2;
        this.Render();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        vtkActor vtkActor2;
        int n;
        vtkActor vtkActor3;
        int n2;
        vtkActorCollection vtkActorCollection2;
        if (this.ren.VisibleActorCount() == 0) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if ('r' == c) {
            this.resetCamera();
            this.Render();
        }
        if ('u' == c) {
            this.pickActor(this.lastX, this.lastY);
        }
        if ('w' == c) {
            vtkActorCollection2 = this.ren.GetActors();
            vtkActorCollection2.InitTraversal();
            for (n2 = 0; n2 < vtkActorCollection2.GetNumberOfItems(); ++n2) {
                vtkActor3 = vtkActorCollection2.GetNextActor();
                vtkActor3.InitPartTraversal();
                for (n = 0; n < vtkActor3.GetNumberOfParts(); ++n) {
                    vtkActor2 = vtkActor3.GetNextPart();
                    vtkActor2.GetProperty().SetRepresentationToWireframe();
                }
            }
            this.Render();
        }
        if ('s' == c) {
            vtkActorCollection2 = this.ren.GetActors();
            vtkActorCollection2.InitTraversal();
            for (n2 = 0; n2 < vtkActorCollection2.GetNumberOfItems(); ++n2) {
                vtkActor3 = vtkActorCollection2.GetNextActor();
                vtkActor3.InitPartTraversal();
                for (n = 0; n < vtkActor3.GetNumberOfParts(); ++n) {
                    vtkActor2 = vtkActor3.GetNextPart();
                    vtkActor2.GetProperty().SetRepresentationToSurface();
                }
            }
            this.Render();
        }
    }

    public void HardCopy(String string, int n) {
        this.Lock();
        vtkWindowToImageFilter vtkWindowToImageFilter2 = new vtkWindowToImageFilter();
        vtkWindowToImageFilter2.SetInput((vtkWindow)this.rw);
        vtkWindowToImageFilter2.SetMagnification(n);
        vtkWindowToImageFilter2.Update();
        vtkTIFFWriter vtkTIFFWriter2 = new vtkTIFFWriter();
        vtkTIFFWriter2.SetInput(vtkWindowToImageFilter2.GetOutput());
        vtkTIFFWriter2.SetFileName(string);
        vtkTIFFWriter2.Write();
        this.UnLock();
    }

    public void pickActor(int n, int n2) {
        vtkPropPicker vtkPropPicker2 = new vtkPropPicker();
        this.Lock();
        vtkPropPicker2.PickProp((double)n, (double)(this.rw.GetSize()[1] - n2), this.ren);
        this.UnLock();
        if (vtkPropPicker2.GetActor() != null) {
            System.out.println(vtkPropPicker2.GetActor().GetClassName());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    static {
        System.loadLibrary("vtkCommonJava");
        System.loadLibrary("vtkFilteringJava");
        System.loadLibrary("vtkIOJava");
        System.loadLibrary("vtkImagingJava");
        System.loadLibrary("vtkGraphicsJava");
        System.loadLibrary("vtkRenderingJava");
        try {
            System.loadLibrary("vtkHybridJava");
        }
        catch (Throwable throwable) {
            System.out.println("cannot load vtkHybrid, skipping...");
        }
    }

    private class WindowObservable
    extends Observable {
        private WindowObservable() {
        }

        public void notifyObservers() {
            this.setChanged();
            super.notifyObservers();
        }

        public void notifyObservers(Object object) {
            this.setChanged();
            super.notifyObservers(object);
        }

        public boolean hasObservers() {
            return 0 < super.countObservers();
        }
    }
}

