/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.info2d;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.plugin.info2d.Infos2DPlugin;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import vtk.vtkDataSet;

public class Info2DControlUI
extends JDialog
implements ActionListener {
    private PipeLineManager pipeLineManager;
    private Infos2DPlugin plugin;
    private VtkObjectComboBoxModel datasetModel;
    private JComboBox inputDataset;
    private JComboBox dataToShow;

    public Info2DControlUI(PipeLineManager pipeLineManager, Infos2DPlugin infos2DPlugin, Frame frame) {
        super(frame, "Info 2D configuration panel");
        this.pipeLineManager = pipeLineManager;
        this.plugin = infos2DPlugin;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), infos2DPlugin.getOutputDataSet());
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Input dataset"));
        this.inputDataset = new JComboBox(this.datasetModel);
        jPanel.add((Component)this.inputDataset, "Center");
        jPanel.setMaximumSize(new Dimension(10000, this.inputDataset.getHeight()));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Data type to show"));
        this.dataToShow = new JComboBox<String>(new String[]{"Ids", "Data field", "Normal", "Scalar", "Coord", "Tensor", "Vector"});
        jPanel.add((Component)this.dataToShow, "Center");
        jPanel.setMaximumSize(new Dimension(10000, this.dataToShow.getHeight()));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.add(Box.createRigidArea(new Dimension(10, 10)), "North");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel();
        JButton jButton = new JButton("Update");
        jButton.setActionCommand("UPDATE");
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("CANCEL");
        jButton2.addActionListener(this);
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(jButton);
        jPanel.add(jButton2);
        this.getContentPane().add(jPanel);
        this.pack();
        Dimension dimension = this.getSize();
        this.setSize(300, dimension.height);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("UPDATE")) {
            if (this.inputDataset.getSelectedItem() != null) {
                this.plugin.updateInfo2D((vtkDataSet)((VtkObject)this.datasetModel.getSelectedItem()).getVtkObject(), this.dataToShow.getSelectedIndex());
                this.pipeLineManager.validateViewAndGo();
            }
        } else if (string.equals("CANCEL")) {
            this.dispose();
        }
    }
}

