/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.text;

import java.awt.Font;
import java.text.BreakIterator;
import org.jfree.text.TextBlock;
import org.jfree.text.TextMeasurer;

public class TextUtilities {
    public static TextBlock createTextBlock(String string, Font font, float f, TextMeasurer textMeasurer) {
        return TextUtilities.createTextBlock(string, font, f, Integer.MAX_VALUE, textMeasurer);
    }

    public static TextBlock createTextBlock(String string, Font font, float f, int n, TextMeasurer textMeasurer) {
        TextBlock textBlock = new TextBlock();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            int n4 = TextUtilities.nextLineBreak(string, n2, f, breakIterator, textMeasurer);
            if (n4 == -1) {
                textBlock.addLine(string.substring(n2), font);
                return textBlock;
            }
            textBlock.addLine(string.substring(n2, n4), font);
            n2 = n4;
        }
        return textBlock;
    }

    private static int nextLineBreak(String string, int n, float f, BreakIterator breakIterator, TextMeasurer textMeasurer) {
        int n2;
        int n3 = n;
        float f2 = 0.0f;
        boolean bl = true;
        while ((n2 = breakIterator.next()) != -1) {
            if ((f2 += textMeasurer.getStringWidth(string, n3, n2)) > f) {
                if (bl) {
                    while (textMeasurer.getStringWidth(string, n, n2) > f) {
                        --n2;
                    }
                    return n2;
                }
                n2 = breakIterator.previous();
                return n2;
            }
            bl = false;
            n3 = n2;
        }
        return -1;
    }
}

