/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import org.jfree.util.Log;
import org.jfree.xml.factory.objects.AbstractObjectDescription;
import org.jfree.xml.factory.objects.ObjectFactoryException;

public class BeanObjectDescription
extends AbstractObjectDescription {
    public BeanObjectDescription(Class clazz) {
        this(clazz, true);
    }

    public BeanObjectDescription(Class clazz, boolean bl) {
        super(clazz);
        if (!bl) {
            return;
        }
        Method[] methodArray = this.getObjectClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
            try {
                String string = this.getPropertyName(method.getName());
                this.findGetMethod(string, method.getParameterTypes()[0]);
                this.setParameterDefinition(string, method.getParameterTypes()[0]);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
    }

    public Object createObject() {
        try {
            Object t = this.getObjectClass().newInstance();
            Iterator iterator = this.getParameterNames();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Method method = this.findSetMethod(string);
                Object object = this.getParameter(string);
                if (object == null) continue;
                method.invoke(t, object);
            }
            return t;
        }
        catch (Exception exception) {
            Log.error("Unable to invoke bean method", exception);
            return null;
        }
    }

    private Method findSetMethod(String string) throws NoSuchMethodException {
        return this.getObjectClass().getMethod(this.getSetterName(string), this.getParameterDefinition(string));
    }

    private Method findGetMethod(String string, Class clazz) throws NoSuchMethodException {
        return this.getObjectClass().getMethod(this.getGetterName(string, clazz), new Class[0]);
    }

    private String getSetterName(String string) {
        if (string.length() == 0) {
            return "set";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("set");
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        if (string.length() > 1) {
            stringBuffer.append(string.substring(1));
        }
        return stringBuffer.toString();
    }

    private String getGetterName(String string, Class clazz) {
        String string2 = "get";
        if (Boolean.TYPE.equals(clazz)) {
            string2 = "is";
        }
        if (string.length() == 0) {
            return string2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append(Character.toUpperCase(string.charAt(0)));
        if (string.length() > 1) {
            stringBuffer.append(string.substring(1));
        }
        return stringBuffer.toString();
    }

    private String getPropertyName(String string) {
        if (string.length() < 3) {
            throw new IllegalArgumentException();
        }
        if (string.length() == 3) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Character.toLowerCase(string.charAt(3)));
        if (string.length() > 4) {
            stringBuffer.append(string.substring(4));
        }
        return stringBuffer.toString();
    }

    public void setParameterFromObject(Object object) throws ObjectFactoryException {
        if (object == null) {
            throw new NullPointerException("Given object is null");
        }
        Class clazz = this.getObjectClass();
        if (!clazz.isInstance(object)) {
            throw new ObjectFactoryException("Object is no instance of " + clazz + "(is " + object.getClass() + ")");
        }
        Iterator iterator = this.getParameterNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                Class clazz2 = this.getParameterDefinition(string);
                Method method = this.findGetMethod(string, clazz2);
                Object object2 = method.invoke(object, new Object[0]);
                if (object2 == null) continue;
                this.setParameter(string, object2);
            }
            catch (Exception exception) {
                Log.info("Exception on method invokation.", exception);
            }
        }
    }
}

