/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.jfree.io.IOUtils;
import org.jfree.util.HashNMap;
import org.jfree.util.Log;
import org.jfree.xml.generator.ModelWriter;
import org.jfree.xml.generator.model.ClassDescription;
import org.jfree.xml.generator.model.DescriptionModel;
import org.jfree.xml.generator.model.ManualMappingInfo;
import org.jfree.xml.generator.model.MappingModel;
import org.jfree.xml.generator.model.MultiplexMappingInfo;

public class SplittingModelWriter
extends ModelWriter {
    private HashNMap classDescriptionByPackage;
    private ArrayList sources;
    private File targetFile;
    private String extension;
    private String plainFileName;
    private HashNMap manualMappingByPackage;
    private HashNMap multiplexMappingByPackage;

    public synchronized void write(String string) throws IOException {
        Object object;
        ManualMappingInfo[] manualMappingInfoArray;
        DescriptionModel descriptionModel = this.getModel();
        this.sources = new ArrayList<String>(Arrays.asList(descriptionModel.getSources()));
        this.targetFile = new File(string);
        this.plainFileName = IOUtils.getInstance().stripFileExtension(this.targetFile.getName());
        this.extension = IOUtils.getInstance().getFileExtension(string);
        this.classDescriptionByPackage = new HashNMap();
        for (int i = 0; i < descriptionModel.size(); ++i) {
            manualMappingInfoArray = descriptionModel.get(i);
            if (manualMappingInfoArray.getSource() == null) {
                String string2 = SplittingModelWriter.getPackage(manualMappingInfoArray.getObjectClass());
                object = this.plainFileName + "-" + string2 + this.extension;
                this.classDescriptionByPackage.add(object, manualMappingInfoArray);
                continue;
            }
            this.classDescriptionByPackage.add(manualMappingInfoArray.getSource(), manualMappingInfoArray);
        }
        MappingModel mappingModel = descriptionModel.getMappingModel();
        manualMappingInfoArray = mappingModel.getManualMapping();
        this.manualMappingByPackage = new HashNMap();
        for (int i = 0; i < manualMappingInfoArray.length; ++i) {
            object = manualMappingInfoArray[i];
            if (((ManualMappingInfo)object).getSource() == null) {
                this.manualMappingByPackage.add("", object);
                continue;
            }
            this.manualMappingByPackage.add(((ManualMappingInfo)object).getSource(), object);
        }
        MultiplexMappingInfo[] multiplexMappingInfoArray = mappingModel.getMultiplexMapping();
        this.multiplexMappingByPackage = new HashNMap();
        for (int i = 0; i < multiplexMappingInfoArray.length; ++i) {
            MultiplexMappingInfo multiplexMappingInfo = multiplexMappingInfoArray[i];
            if (multiplexMappingInfo.getSource() == null) {
                this.multiplexMappingByPackage.add("", multiplexMappingInfo);
                continue;
            }
            this.multiplexMappingByPackage.add(multiplexMappingInfo.getSource(), multiplexMappingInfo);
        }
        Object[] objectArray = this.classDescriptionByPackage.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            String string3 = (String)objectArray[i];
            if (string3.equals("")) continue;
            this.writePackageFile(string3);
        }
        this.writeMasterFile();
        this.manualMappingByPackage = null;
        this.multiplexMappingByPackage = null;
        this.classDescriptionByPackage = null;
        this.sources = null;
    }

    private void writePackageFile(String string) throws IOException, FileNotFoundException {
        Object object;
        Iterator iterator = this.classDescriptionByPackage.getAll(string);
        Iterator iterator2 = this.manualMappingByPackage.getAll(string);
        Iterator iterator3 = this.multiplexMappingByPackage.getAll(string);
        if (!(iterator.hasNext() || iterator2.hasNext() || iterator3.hasNext())) {
            return;
        }
        Log.debug("Writing included file: " + string);
        this.sources.remove(string);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.targetFile.getParentFile(), string)), "UTF-8"));
        SplittingModelWriter.writeXMLHeader(bufferedWriter);
        this.writeStandardComment(bufferedWriter, this.getModel().getModelComments());
        this.getWriterSupport().writeTag(bufferedWriter, "objects");
        while (iterator.hasNext()) {
            object = (ClassDescription)iterator.next();
            this.writeClassDescription(bufferedWriter, (ClassDescription)object);
        }
        while (iterator2.hasNext()) {
            object = (ManualMappingInfo)iterator2.next();
            this.writeManualMapping(bufferedWriter, (ManualMappingInfo)object);
        }
        while (iterator3.hasNext()) {
            object = (MultiplexMappingInfo)iterator3.next();
            this.writeMultiplexMapping(bufferedWriter, (MultiplexMappingInfo)object);
        }
        this.writeCloseComment(bufferedWriter, this.getModel().getModelComments());
        this.getWriterSupport().writeCloseTag(bufferedWriter, "objects");
        bufferedWriter.close();
    }

    public static String getPackage(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n <= 0) {
            return "";
        }
        return string.substring(0, n);
    }

    private void writeMasterFile() throws IOException {
        Object object;
        Object object2;
        Log.debug("Writing master file: " + this.targetFile);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.targetFile), "UTF-8"));
        SplittingModelWriter.writeXMLHeader(bufferedWriter);
        this.writeStandardComment(bufferedWriter, this.getModel().getModelComments());
        this.getWriterSupport().writeTag(bufferedWriter, "objects");
        for (int i = 0; i < this.sources.size(); ++i) {
            String string = (String)this.sources.get(i);
            if (string.equals("")) continue;
            this.writeTag(bufferedWriter, "include", "src", string, this.getModel().getIncludeComment(string));
        }
        Object[] objectArray = this.classDescriptionByPackage.keySet().toArray();
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            object2 = (String)objectArray[i];
            if (((String)object2).equals("")) continue;
            this.writeTag(bufferedWriter, "include", "src", (String)object2, this.getModel().getIncludeComment((String)object2));
        }
        Iterator iterator = this.classDescriptionByPackage.getAll("");
        while (iterator.hasNext()) {
            object2 = (ClassDescription)iterator.next();
            this.writeClassDescription(bufferedWriter, (ClassDescription)object2);
        }
        object2 = this.manualMappingByPackage.getAll("");
        while (object2.hasNext()) {
            object = (ManualMappingInfo)object2.next();
            this.writeManualMapping(bufferedWriter, (ManualMappingInfo)object);
        }
        object = this.multiplexMappingByPackage.getAll("");
        while (object.hasNext()) {
            MultiplexMappingInfo multiplexMappingInfo = (MultiplexMappingInfo)object.next();
            this.writeMultiplexMapping(bufferedWriter, multiplexMappingInfo);
        }
        this.writeCloseComment(bufferedWriter, this.getModel().getModelComments());
        this.getWriterSupport().writeCloseTag(bufferedWriter, "objects");
        bufferedWriter.close();
    }
}

