/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.about;

import java.awt.BorderLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import org.jfree.ui.about.SystemProperties;

public class SystemPropertiesPanel
extends JPanel {
    private JTable table;
    private JPopupMenu copyPopupMenu;
    private JMenuItem copyMenuItem;
    private PopupListener copyPopupListener;

    public SystemPropertiesPanel() {
        String string = "org.jfree.ui.about.resources.AboutResources";
        ResourceBundle resourceBundle = ResourceBundle.getBundle(string);
        this.setLayout(new BorderLayout());
        this.table = SystemProperties.createSystemPropertiesTable();
        this.add(new JScrollPane(this.table));
        this.copyPopupMenu = new JPopupMenu();
        String string2 = resourceBundle.getString("system-properties-panel.popup-menu.copy");
        KeyStroke keyStroke = (KeyStroke)resourceBundle.getObject("system-properties-panel.popup-menu.copy.accelerator");
        this.copyMenuItem = new JMenuItem(string2);
        this.copyMenuItem.setAccelerator(keyStroke);
        this.copyMenuItem.getAccessibleContext().setAccessibleDescription(string2);
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SystemPropertiesPanel.this.copySystemPropertiesToClipboard();
            }
        });
        this.copyPopupMenu.add(this.copyMenuItem);
        this.copyPopupListener = new PopupListener();
        this.table.addMouseListener(this.copyPopupListener);
    }

    public void copySystemPropertiesToClipboard() {
        StringBuffer stringBuffer = new StringBuffer();
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        int n = listSelectionModel.getMinSelectionIndex();
        int n2 = listSelectionModel.getMaxSelectionIndex();
        if (n != -1 && n2 != -1) {
            for (int i = n; i <= n2; ++i) {
                for (int j = 0; j < this.table.getColumnCount(); ++j) {
                    stringBuffer.append(this.table.getValueAt(i, j));
                    if (j == 2) continue;
                    stringBuffer.append("\t");
                }
                stringBuffer.append("\n");
            }
        }
        StringSelection stringSelection = new StringSelection(stringBuffer.toString());
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SystemPropertiesPanel.this.copyPopupMenu.show(SystemPropertiesPanel.this.table, mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

