# This example demonstrates the use of vtkAssembly.  In an assembly,
# the motion of one actor affects the position of other actors.

import vtk
from java.awt import Color

# Create four parts: a top level assembly (in this case, a
# vtkCylinder) and three primitives (using vtkSphereSource,
# vtkCubeSource, and vtkConeSource).  Set up mappers and actors for
# each part of the assembly to carry information about material
# properties and associated geometry.


space = 0.5
#Task Manager
Lx = 100.0
Ly = 10.0
Lz = 30.0
tm = vtk.vtkCubeSource()
tm.SetXLength(Lx)
tm.SetZLength(Lz)
tm.SetYLength(Ly)
tmMapper = vtk.vtkPolyDataMapper()
tmMapper.SetInput(tm.GetOutput())
tmActor = vtk.vtkActor()
tmActor.SetMapper(tmMapper)
tmActor.SetPosition(0.0,0.0, 0)
tmActor.GetProperty().SetColor(0, 1, 1)

atext = vtk.vtkVectorText()
atext.SetText("Task Manager")
textMapper = vtk.vtkPolyDataMapper()
textMapper.SetInput(atext.GetOutput())
textActor = vtk.vtkFollower()
textActor.SetMapper(textMapper)
textActor.SetScale(3, 3, 3)
textActor.SetPosition(-Lx*0.4,-Ly, (Lz*0.5+1.9))
textActor.AddPosition(0, 0, 0)
textActor.GetProperty().SetColor(1, 0, 0.5)


#databus
db = vtk.vtkCubeSource()
db.SetXLength(Lx)
db.SetYLength(Ly)
db.SetZLength(Lz)
dbMapper = vtk.vtkPolyDataMapper()
dbMapper.SetInput(db.GetOutput())
dbActor = vtk.vtkActor()
dbActor.SetMapper(dbMapper)
dbActor.SetPosition(0.0,-(Ly+space),0.0)
dbActor.GetProperty().SetColor(1, 1, 1)

dbtext = vtk.vtkVectorText()
dbtext.SetText("Data Bus")
dbtextMapper = vtk.vtkPolyDataMapper()
dbtextMapper.SetInput(dbtext.GetOutput())
dbtextActor = vtk.vtkFollower()
dbtextActor.SetMapper(dbtextMapper)
dbtextActor.SetScale(3, 3, 3)
dbtextActor.SetPosition(-Lx*0.4,-Ly-(-(Ly+space)), (Lz*0.5+1.9))
dbtextActor.AddPosition(0, 0, 0)
dbtextActor.GetProperty().SetColor(1, 0, 0.5)

#spis Num
lx = Lx*0.2
ly = 40.0
lz = 30.0
num = vtk.vtkCubeSource()
num.SetXLength(lx)
num.SetYLength(ly)
num.SetZLength(lz)
numMapper = vtk.vtkPolyDataMapper()
numMapper.SetInput(num.GetOutput())
numActor = vtk.vtkActor()
numActor.SetMapper(numMapper)
numActor.SetPosition(0.0,(Ly*0.5+space+ly*0.5),0.0)
numActor.GetProperty().SetColor(1, 1, 0)

numtext = vtk.vtkVectorText()
numtext.SetText("NUM")
numtextMapper = vtk.vtkPolyDataMapper()
numtextMapper.SetInput(numtext.GetOutput())
numtextActor = vtk.vtkFollower()
numtextActor.SetMapper(numtextMapper)
numtextActor.SetScale(3, 3, 3)
numtextActor.SetPosition(-lx*0.4, Ly+space, (Lz*0.5+1.9))
numtextActor.AddPosition(0, 0, 0)
numtextActor.GetProperty().SetColor(1, 0, 0.5)


# Create the assembly and add the 4 parts to it.  Also set the origin,
# position and orientation in space.
assembly = vtk.vtkAssembly()
#assembly.AddPart(cylinderActor)
#assembly.AddPart(sphereActor)
assembly.AddPart(tmActor)
assembly.AddPart(textActor)
assembly.AddPart(dbActor)
assembly.AddPart(dbtextActor)
assembly.AddPart(numActor)
assembly.AddPart(numtextActor)
#assembly.SetOrigin(5, 10, 15)
#assembly.AddPosition(5, 0, 0)
#assembly.RotateX(15)


vtkCassandraAssembly = cassandra.getPipeLineManager().addActor(assembly,"Assembly")
cassandra.getPipeLineManager().setActorVisible(vtkCassandraAssembly,1)
cassandra.getPipeLineManager().getCassandraView().setBackground(Color(25,50,100))


# Set up the camera to get a particular view of the scene
camera = vtk.vtkCamera()
camera.SetClippingRange(21.9464, 30.0179)
camera.SetFocalPoint(3.49221, 2.28844, -0.970866)
camera.SetPosition(3.49221, 2.28844, 24.5216)
camera.SetViewAngle(30)
camera.SetViewUp(0, 1, 0)
cassandra.getPipeLineManager().getCassandraView().GetRenderer().SetActiveCamera(camera)
