import time
from vtk import *
from java.util import ArrayList
from java.io import File
from com.artenum.cassandra.util import *
from java.lang import Runnable
from javax.swing import SwingUtilities
#
# Get the main objects
#

path_sat = "./Data/Sat-Plasma/spacecraft.vtk"
path_plasma = "./Data/Sat-Plasma/plasma.vtk"
outputImageBasePath = "./Data/sat-images/"


pipeLineManager = cassandra.getPipeLineManager()
view = pipeLineManager.getCassandraView()
pipeLineManager.addVtkFile(File(path_sat))
pipeLineManager.addVtkFile(File(path_plasma))
cassandra.getDefaultUI().hidePipeLine()
cassandra.getDefaultUI().hideConsole()

sat_dataset = pipeLineManager.getDataSetList().getElementAt(0).getVtkObject()
plasma_dataset = pipeLineManager.getDataSetList().getElementAt(1).getVtkObject()

plasma_actor = pipeLineManager.getActorList().getElementAt(1).getVtkObject()

level_start = -0.1529
step = 0.001
nbStep = 140

isoLevel = IsoLevelPipeLine(plasma_dataset, level_start,0)
isoLevelActor = isoLevel.getActor()
isoLevelActor.GetProperty().SetOpacity(0.5)

class GuiWorker(Runnable):
   def __init__(self, pipeLineManager,view):
       self.pipeLineManager = pipeLineManager
       self.view = view

   def run(self):
       self.pipeLineManager.setActorVisible(pipeLineManager.addActor(isoLevelActor, "IsoLevel"),1)
       self.pipeLineManager.setActorVisible(pipeLineManager.getActorList().getElementAt(0),1)
       self.pipeLineManager.setActorVisible(pipeLineManager.getActorList().getElementAt(1),0)
       self.pipeLineManager.setActorVisible(pipeLineManager.getActorList().getElementAt(2),1)
       self.pipeLineManager.setActorVisible(pipeLineManager.getScalarBarList().getElementAt(0),0)
       self.pipeLineManager.setActorVisible(pipeLineManager.getScalarBarList().getElementAt(1),0)

       self.view.rotate(90,0)
       self.view.rotate(0,90)
       self.view.rotate(75,0)
       self.view.rotate(0,15)
       self.view.zoom(4.5)


SwingUtilities.invokeAndWait(GuiWorker(pipeLineManager, view))

