"""
**Description:** script to display node Ids in Cassandra

**File name:**    showIds.py

**Creation:**     2005/08/28

**References:** Please see the Cassandra web site http://www.artem.com for
more information.

:author:       Julien Forest

:version:      1.0

**Versions and anomalies correction :**

+---------+--------------------------------------+----------------------------+
| Version | Author (name, e-mail)                | Corrections/Modifications  |
+---------+--------------------------------------+----------------------------+
|   1.0   | Julien Forest                        | Creation                   |
|         | j.forest@artenum.com                 |                            |
+---------+--------------------------------------+----------------------------+

(c) PARIS, 2000-2004, Paris, France, `http://www.artenum.com`_

"""
__docformat__ = "restructuredtext en"

import vtk

print "Show Ids script" 

# choose here the dataSet that you want process
data = cassandra.getPipeLineManager().getDataSetList().getVtkObject(0)

label = vtk.vtkLabeledDataMapper()
label.SetInput(data.getVtkObject())
label.SetLabelModeToLabelIds()
label.SetLabelFormat("%g")

label.SetLabelModeToLabelIds()
pointLabels = vtk.vtkActor2D()
pointLabels.SetMapper(label)

# recover Cassandra's renderer
cassandra.getPipeLineManager().addActor(pointLabels,"ids")

print "Done"
