"""
**Description:** change the size of the nodes in Cassandra

**File name:**    setPointSize.py

**Creation:**     2005/07/28

**References:** Please see the Cassandra web site http://www.artem.com for
more information.

:author:       Julien Forest

:version:      1.0

**Versions and anomalies correction :**

+---------+--------------------------------------+----------------------------+
| Version | Author (name, e-mail)                | Corrections/Modifications  |
+---------+--------------------------------------+----------------------------+
|   1.0   | Julien Forest                        | Creation                   |
|         | j.forest@artenum.com                 |                            |
+---------+--------------------------------------+----------------------------+

(c) PARIS, 2000-2004, Paris, France, `http://www.artenum.com`_

"""
__docformat__ = "restructuredtext en"


import com.artenum.cassandra.util

from pawt import swing
from javax.swing import *
from java.awt import *
import pawt
import java
import DataListChooser


def okAction(e):
    '''
    Define the action.
    '''
    cassandra.getPipeLineManager().validateView()
    actor = comboBox1.getSelectedItem().getVtkObject()
    ptSize = ptSizeSlide1.getValue()
    actor.GetProperty().SetPointSize(ptSize)
    cassandra.getPipeLineManager().validateView()
    frame.dispose()
    print "Done"



# creation of the control frame
frame = swing.JFrame('Actor selection', visible=1)

comboBox1 = JComboBox(com.artenum.cassandra.util.VtkObjectComboBoxModel(cassandra.getPipeLineManager().getActorList(), None))
frame.contentPane.add(comboBox1, BorderLayout.NORTH)

centralPanel = JPanel()
ptSizeSlide1 =  JSlider()
ptSizeSlide1.setMinimum(0)
ptSizeSlide1.setMaximum(10)
ptSizeSlide1.setMinorTickSpacing(1)
ptSizeSlide1.setMajorTickSpacing(10)
centralPanel.add(ptSizeSlide1)
frame.contentPane.add(centralPanel, BorderLayout.CENTER)

button = swing.JButton('OK', actionPerformed = okAction)
frame.contentPane.add(button, BorderLayout.SOUTH)
frame.setSize(312, 90)
frame.show()


