/*
 * Decompiled with CFR 0.152.
 */
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkAxes;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkRenderer;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class AxesActor
extends vtkAssembly {
    private vtkRenderer ren;
    private double axisLength = 0.8;
    private double axisTextLength = 1.2;
    private vtkTextActor xactor;
    private vtkTextActor yactor;
    private vtkTextActor zactor;

    public AxesActor(vtkRenderer vtkRenderer2) {
        this.ren = vtkRenderer2;
        this.createAxes();
    }

    public void createAxes() {
        vtkAxes vtkAxes2 = new vtkAxes();
        vtkAxes2.SetOrigin(0.0, 0.0, 0.0);
        vtkAxes2.SetScaleFactor(this.axisLength);
        this.xactor = new vtkTextActor();
        this.yactor = new vtkTextActor();
        this.zactor = new vtkTextActor();
        this.xactor.SetInput("X");
        this.yactor.SetInput("Y");
        this.zactor.SetInput("Z");
        this.xactor.ScaledTextOn();
        this.yactor.ScaledTextOn();
        this.zactor.ScaledTextOn();
        this.xactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.yactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.zactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.xactor.GetPositionCoordinate().SetValue(this.axisLength, 0.0, 0.0);
        this.yactor.GetPositionCoordinate().SetValue(0.0, this.axisLength, 0.0);
        this.zactor.GetPositionCoordinate().SetValue(0.0, 0.0, this.axisLength);
        this.xactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.xactor.GetTextProperty().ShadowOn();
        this.xactor.GetTextProperty().ItalicOn();
        this.xactor.GetTextProperty().BoldOff();
        this.yactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.yactor.GetTextProperty().ShadowOn();
        this.yactor.GetTextProperty().ItalicOn();
        this.yactor.GetTextProperty().BoldOff();
        this.zactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.zactor.GetTextProperty().ShadowOn();
        this.zactor.GetTextProperty().ItalicOn();
        this.zactor.GetTextProperty().BoldOff();
        this.xactor.SetMaximumLineHeight(0.25);
        this.yactor.SetMaximumLineHeight(0.25);
        this.zactor.SetMaximumLineHeight(0.25);
        vtkTubeFilter vtkTubeFilter2 = new vtkTubeFilter();
        vtkTubeFilter2.SetInput((vtkDataObject)vtkAxes2.GetOutput());
        vtkTubeFilter2.SetRadius(0.05);
        vtkTubeFilter2.SetNumberOfSides(8);
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInput(vtkTubeFilter2.GetOutput());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper((vtkMapper)vtkPolyDataMapper2);
        vtkActor2.PickableOff();
        int n = 12;
        double d = 0.3;
        vtkConeSource vtkConeSource2 = new vtkConeSource();
        vtkConeSource2.SetResolution(n);
        vtkPolyDataMapper vtkPolyDataMapper3 = new vtkPolyDataMapper();
        vtkPolyDataMapper3.SetInput(vtkConeSource2.GetOutput());
        vtkActor vtkActor3 = new vtkActor();
        vtkActor3.SetMapper((vtkMapper)vtkPolyDataMapper3);
        vtkActor3.GetProperty().SetColor(1.0, 0.0, 0.0);
        vtkActor3.SetScale(d, d, d);
        vtkActor3.SetPosition(this.axisLength, 0.0, 0.0);
        vtkConeSource vtkConeSource3 = new vtkConeSource();
        vtkConeSource3.SetResolution(n);
        vtkPolyDataMapper vtkPolyDataMapper4 = new vtkPolyDataMapper();
        vtkPolyDataMapper4.SetInput(vtkConeSource3.GetOutput());
        vtkActor vtkActor4 = new vtkActor();
        vtkActor4.SetMapper((vtkMapper)vtkPolyDataMapper4);
        vtkActor4.GetProperty().SetColor(1.0, 1.0, 0.0);
        vtkActor4.RotateZ(90.0);
        vtkActor4.SetScale(d, d, d);
        vtkActor4.SetPosition(0.0, this.axisLength, 0.0);
        vtkConeSource vtkConeSource4 = new vtkConeSource();
        vtkConeSource4.SetResolution(n);
        vtkPolyDataMapper vtkPolyDataMapper5 = new vtkPolyDataMapper();
        vtkPolyDataMapper5.SetInput(vtkConeSource4.GetOutput());
        vtkActor vtkActor5 = new vtkActor();
        vtkActor5.SetMapper((vtkMapper)vtkPolyDataMapper5);
        vtkActor5.GetProperty().SetColor(0.0, 1.0, 0.0);
        vtkActor5.RotateY(-90.0);
        vtkActor5.SetScale(d, d, d);
        vtkActor5.SetPosition(0.0, 0.0, this.axisLength);
        this.ren.AddActor2D((vtkProp)this.xactor);
        this.ren.AddActor2D((vtkProp)this.yactor);
        this.ren.AddActor2D((vtkProp)this.zactor);
        this.AddPart((vtkProp3D)vtkActor2);
        this.AddPart((vtkProp3D)vtkActor3);
        this.AddPart((vtkProp3D)vtkActor4);
        this.AddPart((vtkProp3D)vtkActor5);
        this.ren.AddActor((vtkProp)this);
    }

    public void setAxesVisibility(boolean bl) {
        this.SetVisibility(bl ? 1 : 0);
        this.xactor.SetVisibility(bl ? 1 : 0);
        this.yactor.SetVisibility(bl ? 1 : 0);
        this.zactor.SetVisibility(bl ? 1 : 0);
    }
}

