/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline;

import com.artenum.cassandra.pipeline.VtkObject;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class VtkObjectListModel
extends AbstractListModel
implements ListCellRenderer {
    private ArrayList vtkObjectList = new ArrayList();
    private JLabel renderer = new JLabel();
    private Color selectedColor;
    private Color defaultColor;
    private int modelType;
    private boolean showTypeError = false;

    public VtkObjectListModel(int n) {
        this.renderer.setOpaque(true);
        this.selectedColor = new Color(100, 100, 200);
        this.defaultColor = Color.white;
        this.modelType = n;
    }

    public void setPrefference(Color color, Color color2, boolean bl) {
        if (color != null) {
            this.selectedColor = color;
        }
        if (color2 != null) {
            this.defaultColor = color2;
        }
        this.showTypeError = bl;
    }

    @Override
    public int getSize() {
        return this.vtkObjectList.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.vtkObjectList.get(n);
    }

    public void addVtkObject(VtkObject vtkObject) {
        if (vtkObject.getType() == this.modelType) {
            this.vtkObjectList.add(vtkObject);
            this.fireIntervalAdded(this, this.getSize() - 1, this.getSize() - 1);
        } else if (this.showTypeError) {
            System.err.println("Try to ADD invalide type in the VtkObjectListModel. (Expected: " + this.modelType + " / Got: " + vtkObject.getType() + ")");
        }
    }

    public void removeVtkObject(VtkObject vtkObject) {
        if (vtkObject.getType() == this.modelType) {
            int n = this.vtkObjectList.indexOf(vtkObject);
            if (n != -1) {
                this.vtkObjectList.remove(n);
            }
            this.fireIntervalRemoved(this, n, n);
        } else if (this.showTypeError) {
            System.err.println("Try to REMOVE invalide type in the VtkObjectListModel. (Expected: " + this.modelType + " / Got: " + vtkObject.getType() + ")");
        }
    }

    public VtkObject getVtkObject(int n) {
        return (VtkObject)this.getElementAt(n);
    }

    public VtkObject getVtkObject(Object object) {
        for (VtkObject vtkObject : this.vtkObjectList) {
            if (!vtkObject.getVtkObject().equals(object)) continue;
            return vtkObject;
        }
        return null;
    }

    public int getVtkObjectIndex(VtkObject vtkObject) {
        return this.vtkObjectList.indexOf(vtkObject);
    }

    public VtkObject getLastVtkObject() {
        return this.getVtkObject(this.getSize() - 1);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.renderer.setBackground(bl ? this.selectedColor : this.defaultColor);
        VtkObject vtkObject = (VtkObject)object;
        this.renderer.setText(vtkObject.getName() + " (" + n + ")");
        return this.renderer;
    }

    public Collection getData() {
        return this.vtkObjectList;
    }
}

