/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.ui.dialog;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.util.CassandraToolBox;
import com.artenum.cassandra.util.VtkObjectComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import vtk.vtkDataSet;
import vtk.vtkLookupTable;

public class LookUpTableControlDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    private VtkObject lookupTable;
    private PipeLineManager pipelineManager;
    private VtkObjectComboBoxModel datasetModel;
    private JList multiDatasetForRange;
    private JFormattedTextField nbColor;
    private JFormattedTextField min;
    private JFormattedTextField max;
    private JFormattedTextField minHue;
    private JFormattedTextField maxHue;
    private JRadioButton rampLinear;
    private JRadioButton rampSCurve;
    private JRadioButton rampSQRT;
    private JRadioButton scaleLinear;
    private JRadioButton scaleLog10;
    private JButton exit;
    private JButton update;

    public LookUpTableControlDialog(Frame frame, PipeLineManager pipeLineManager) {
        super(frame, "Lookup Table control");
        this.pipelineManager = pipeLineManager;
        this.datasetModel = new VtkObjectComboBoxModel(pipeLineManager.getDataSetList(), null);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Dataset scalar range"));
        this.multiDatasetForRange = new JList(this.datasetModel);
        this.multiDatasetForRange.addListSelectionListener(this);
        jPanel.add((Component)new JScrollPane(this.multiDatasetForRange), "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Range"));
        JPanel jPanel2 = new JPanel(new GridLayout(3, 0));
        JPanel jPanel3 = new JPanel(new GridLayout(3, 0));
        this.nbColor = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.nbColor.setColumns(20);
        this.min = new JFormattedTextField((Object)"0");
        this.min.setValue(new Double(0.0));
        this.max = new JFormattedTextField((Object)"0");
        this.max.setValue(new Double(1.0));
        jPanel2.add(new JLabel("Number of color : ", 4));
        jPanel2.add(new JLabel("Min : ", 4));
        jPanel2.add(new JLabel("Max : ", 4));
        jPanel3.add(this.nbColor);
        jPanel3.add(this.min);
        jPanel3.add(this.max);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Huge range"));
        jPanel2 = new JPanel(new GridLayout(2, 0));
        jPanel3 = new JPanel(new GridLayout(2, 0));
        this.minHue = new JFormattedTextField((Object)"0");
        this.minHue.setValue(new Double(0.0));
        this.maxHue = new JFormattedTextField((Object)"0");
        this.maxHue.setValue(new Double(0.0));
        jPanel2.add(new JLabel("Min : ", 4));
        jPanel2.add(new JLabel("Max : ", 4));
        jPanel3.add(this.minHue);
        jPanel3.add(this.maxHue);
        jPanel.add((Component)jPanel2, "West");
        jPanel.add((Component)jPanel3, "Center");
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(0, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Ramp"));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.rampLinear = new JRadioButton("Linear");
        this.rampSCurve = new JRadioButton("Curve");
        this.rampSQRT = new JRadioButton("Square root");
        buttonGroup.add(this.rampLinear);
        buttonGroup.add(this.rampSCurve);
        buttonGroup.add(this.rampSQRT);
        jPanel.add(this.rampLinear);
        jPanel.add(this.rampSCurve);
        jPanel.add(this.rampSQRT);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new GridLayout(0, 2));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Scale"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.scaleLinear = new JRadioButton("Linear");
        this.scaleLog10 = new JRadioButton("log10");
        buttonGroup2.add(this.scaleLinear);
        buttonGroup2.add(this.scaleLog10);
        jPanel.add(this.scaleLinear);
        jPanel.add(this.scaleLog10);
        this.getContentPane().add(jPanel);
        this.update = new JButton("Update");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookUpTableControlDialog.this.updateLookupTable();
            }
        });
        this.exit = new JButton("Cancel");
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookUpTableControlDialog.this.dispose();
            }
        });
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.update);
        jPanel.add(this.exit);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(frame);
    }

    public void setLookupTable(VtkObject vtkObject) {
        this.lookupTable = vtkObject;
        switch (this.getVtkLookUpTable().GetRamp()) {
            case 0: {
                this.rampLinear.setSelected(true);
                break;
            }
            case 1: {
                this.rampSCurve.setSelected(true);
                break;
            }
            case 2: {
                this.rampSQRT.setSelected(true);
            }
        }
        switch (this.getVtkLookUpTable().GetScale()) {
            case 0: {
                this.scaleLinear.setSelected(true);
                break;
            }
            case 1: {
                this.scaleLog10.setSelected(true);
            }
        }
        double[] dArray = this.getVtkLookUpTable().GetTableRange();
        double[] dArray2 = this.getVtkLookUpTable().GetHueRange();
        this.min.setValue(new Double(dArray[0]));
        this.max.setValue(new Double(dArray[1]));
        this.minHue.setValue(new Double(dArray2[0]));
        this.maxHue.setValue(new Double(dArray2[1]));
        this.nbColor.setValue(new Integer(this.getVtkLookUpTable().GetNumberOfColors()));
    }

    public void updateLookupTable() {
        if (this.rampLinear.isSelected()) {
            this.getVtkLookUpTable().SetRampToLinear();
        }
        if (this.rampSCurve.isSelected()) {
            this.getVtkLookUpTable().SetRampToSCurve();
        }
        if (this.rampSQRT.isSelected()) {
            this.getVtkLookUpTable().SetRampToSQRT();
        }
        if (this.scaleLinear.isSelected()) {
            this.getVtkLookUpTable().SetScaleToLinear();
        }
        if (this.scaleLog10.isSelected()) {
            this.getVtkLookUpTable().SetScaleToLog10();
        }
        this.getVtkLookUpTable().SetNumberOfColors(((Number)this.nbColor.getValue()).intValue());
        this.getVtkLookUpTable().SetRange(((Number)this.min.getValue()).doubleValue(), ((Number)this.max.getValue()).doubleValue());
        this.getVtkLookUpTable().SetHueRange(((Number)this.minHue.getValue()).doubleValue(), ((Number)this.maxHue.getValue()).doubleValue());
        CassandraToolBox.updateMapper(this.pipelineManager, this.getVtkLookUpTable());
        this.getVtkLookUpTable().Build();
        this.pipelineManager.notifyConnectivityChange(this.lookupTable);
        this.pipelineManager.validateViewAndGo();
    }

    public vtkLookupTable getVtkLookUpTable() {
        return (vtkLookupTable)this.lookupTable.getVtkObject();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object e = this.multiDatasetForRange.getSelectedValue();
        if (e != null) {
            double[] dArray = ((vtkDataSet)((VtkObject)e).getVtkObject()).GetScalarRange();
            this.min.setValue(new Double(dArray[0]));
            this.max.setValue(new Double(dArray[1]));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        double d = 0.0;
        double d2 = 0.0;
        Object[] objectArray = this.multiDatasetForRange.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            double[] dArray = ((vtkDataSet)((VtkObject)objectArray[i]).getVtkObject()).GetScalarRange();
            if (i == 0) {
                d = dArray[0];
                d2 = dArray[1];
            }
            if (d > dArray[0]) {
                d = dArray[0];
            }
            if (!(d2 < dArray[1])) continue;
            d2 = dArray[1];
        }
        if (d != d2) {
            this.min.setValue(new Double(d));
            this.max.setValue(new Double(d2));
        }
    }
}

