/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VtkObjectComboBoxModel
implements ComboBoxModel,
ListDataListener {
    private VtkObject filteredItem;
    private VtkObject selectedItem;
    private VtkObjectListModel listModel;
    private int filteredIndex = -1;

    public VtkObjectComboBoxModel(VtkObjectListModel vtkObjectListModel, VtkObject vtkObject) {
        this.filteredItem = vtkObject;
        this.listModel = vtkObjectListModel;
        this.filteredIndex = vtkObjectListModel.getVtkObjectIndex(vtkObject);
        this.listModel.addListDataListener(this);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object object) {
        this.selectedItem = (VtkObject)object;
    }

    public void setSelectedEncapsulateItem(Object object) {
        this.selectedItem = this.listModel.getVtkObject(object);
    }

    @Override
    public int getSize() {
        return this.listModel.getSize() - (this.filteredIndex != -1 ? 1 : 0);
    }

    @Override
    public Object getElementAt(int n) {
        if (this.filteredIndex != -1 && this.filteredIndex < n) {
            --n;
        }
        return this.listModel.getElementAt(n);
    }

    @Override
    public void addListDataListener(ListDataListener listDataListener) {
        this.listModel.addListDataListener(listDataListener);
    }

    @Override
    public void removeListDataListener(ListDataListener listDataListener) {
        this.listModel.removeListDataListener(listDataListener);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.filteredIndex = this.listModel.getVtkObjectIndex(this.filteredItem);
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.filteredIndex = this.listModel.getVtkObjectIndex(this.filteredItem);
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.filteredIndex = this.listModel.getVtkObjectIndex(this.filteredItem);
    }
}

