/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import vtk.vtkLookupTable;

public class VtkObjectUI2
extends JLabel
implements VtkObjectUI {
    private VtkObject object;
    protected final Dimension size = new Dimension(59, 66);
    protected Point position;
    protected String txt;
    protected ImageIcon glassIcon;
    protected ImageIcon glassIcon2;
    protected ImageIcon icon;
    private final int deltaX = 100;
    private final int deltaY = 80;

    public VtkObjectUI2(VtkObject vtkObject) {
        this.object = vtkObject;
        this.position = new Point(10, 10);
        this.txt = vtkObject.getName();
        this.setToolTipText(this.txt);
        if (this.txt.length() > 6) {
            this.txt = this.txt.substring(0, 6);
            this.txt = this.txt + "...";
        }
        switch (vtkObject.getType()) {
            case 1: {
                this.icon = VtkObjectUI2.createImageIcon("icon/actor.png", "Actor");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/actorEye.png", "Visible");
                this.position.x = 400;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 2: {
                this.icon = VtkObjectUI2.createImageIcon("icon/mapper.png", "Mapper");
                this.txt = "";
                this.position.x = 300;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 3: {
                this.icon = VtkObjectUI2.createImageIcon("icon/dataset.png", "DataSet");
                this.position.x = 200;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 4: {
                this.icon = VtkObjectUI2.createImageIcon("icon/filter.png", "Filter");
                this.position.x = 100;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 5: {
                this.icon = VtkObjectUI2.createImageIcon("icon/lookuptable.png", "Lookup Table");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/linearLT.png", "Lookup Table");
                this.glassIcon2 = VtkObjectUI2.createImageIcon("icon/logLT.png", "Lookup Table");
                this.position.x = 500;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 6: {
                this.icon = VtkObjectUI2.createImageIcon("icon/scalarBar.png", "ScalarBar");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/actorEye.png", "Visible");
                this.position.x = 600;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
                break;
            }
            case 7: {
                this.icon = VtkObjectUI2.createImageIcon("icon/txtActor.png", "Text actor");
                this.glassIcon = VtkObjectUI2.createImageIcon("icon/txtActorEye.png", "Visible");
                this.position.x = 700;
                this.position.y += (vtkObject.getLocalTypeId() - 1) * 80;
            }
        }
        this.setIcon(this.icon);
    }

    @Override
    public void setName(String string) {
        this.txt = string;
        this.repaint();
    }

    protected static ImageIcon createImageIcon(String string, String string2) {
        URL uRL = VtkObjectCellAdapter.class.getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find file: " + uRL);
        return null;
    }

    public void savePosition() {
        this.position = this.getLocation();
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    public void setPosition(Point point) {
        this.position = point;
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if ((this.object.getType() == 1 || this.object.getType() == 6 || this.object.getType() == 7) && this.object.getMetaData().get("ACTOR_VISIBLE") != null) {
            if (((String)this.object.getMetaData().get("ACTOR_VISIBLE")).equals("true")) {
                graphics.drawImage(this.glassIcon.getImage(), 0, 0, this.glassIcon.getImageObserver());
            }
        } else if (this.object.getType() == 5) {
            if (((vtkLookupTable)this.object.getVtkObject()).GetScale() == 0) {
                graphics.drawImage(this.glassIcon.getImage(), 0, 0, this.glassIcon.getImageObserver());
            } else {
                graphics.drawImage(this.glassIcon2.getImage(), 0, 0, this.glassIcon2.getImageObserver());
            }
        }
        Rectangle2D rectangle2D = graphics.getFontMetrics().getStringBounds(this.txt, graphics);
        int n = (int)(59.0 - rectangle2D.getWidth()) / 2;
        graphics.drawString(this.txt, n, 66);
    }
}

