/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.ConnectivityListener;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.graph.impl.DefaultGraphModel;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.GraphViewListener;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;

public class VtkPipeLineGraphModel
extends DefaultGraphModel
implements ListDataListener,
ConnectivityListener {
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private int lastYPos = 0;

    public VtkPipeLineGraphModel(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        pipeLineManager.getActorList().addListDataListener((ListDataListener)this);
        pipeLineManager.getMapperList().addListDataListener((ListDataListener)this);
        pipeLineManager.getDataSetList().addListDataListener((ListDataListener)this);
        pipeLineManager.getFilterList().addListDataListener((ListDataListener)this);
        pipeLineManager.getLookupTableList().addListDataListener((ListDataListener)this);
        pipeLineManager.getScalarBarList().addListDataListener((ListDataListener)this);
        pipeLineManager.getTextActorList().addListDataListener((ListDataListener)this);
        pipeLineManager.addConnectivityListener((ConnectivityListener)this);
    }

    @Override
    public void contentsChanged(ListDataEvent listDataEvent) {
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    public void reload() {
        Object[] objectArray = this.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((VtkObjectCellAdapter)objectArray[i]).savePosition();
        }
        super.reload();
    }

    public void updateCell() {
        VtkObjectUI vtkObjectUI;
        VtkObject vtkObject2 = null;
        VtkObjectCellAdapter vtkObjectCellAdapter = null;
        for (VtkObject vtkObject2 : this.pipeLineManager.getActorList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        for (VtkObject vtkObject2 : this.pipeLineManager.getMapperList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        for (VtkObject vtkObject2 : this.pipeLineManager.getDataSetList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
                vtkObjectUI = (VtkObjectUI)((Object)vtkObjectCellAdapter.getUI());
                if (vtkObjectUI.getPosition().y > this.lastYPos) {
                    this.lastYPos = vtkObjectUI.getPosition().y;
                }
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        for (VtkObject vtkObject2 : this.pipeLineManager.getFilterList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
                vtkObjectUI = (VtkObjectUI)((Object)vtkObjectCellAdapter.getUI());
                if (vtkObjectUI.getPosition().y < this.lastYPos) {
                    vtkObjectUI.getPosition().y = this.lastYPos;
                }
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        for (VtkObject vtkObject2 : this.pipeLineManager.getLookupTableList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        for (VtkObject vtkObject2 : this.pipeLineManager.getScalarBarList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
        for (VtkObject vtkObject2 : this.pipeLineManager.getTextActorList().getData()) {
            if (vtkObject2.getMetaData().get("CELL") == null) {
                vtkObjectCellAdapter = new VtkObjectCellAdapter(vtkObject2);
                vtkObject2.getMetaData().put("CELL", vtkObjectCellAdapter);
            } else {
                vtkObjectCellAdapter = (VtkObjectCellAdapter)vtkObject2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(vtkObjectCellAdapter)) continue;
            this.insertCell(vtkObjectCellAdapter);
        }
    }

    public void updateConnection() {
        this.getConnections().clear();
        Object[] objectArray = this.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            ((Cell)objectArray[i]).getConnections().clear();
        }
        for (VtkObject vtkObject : this.pipeLineManager.getActorList().getData()) {
            if (!(vtkObject.getVtkObject() instanceof vtkActor)) continue;
            Object object = ((vtkActor)vtkObject.getVtkObject()).GetMapper();
            for (VtkObject vtkObject2 : this.pipeLineManager.getMapperList().getData()) {
                if (!vtkObject2.getVtkObject().equals(object)) continue;
                this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
            }
        }
        for (VtkObject vtkObject : this.pipeLineManager.getDataSetList().getData()) {
            for (Object object : this.pipeLineManager.getMapperList().getData()) {
                if (((vtkMapper)object.getVtkObject()).GetInputAsDataSet() == null || !((vtkMapper)object.getVtkObject()).GetInputAsDataSet().equals(vtkObject.getVtkObject())) continue;
                this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)object.getMetaData().get("CELL"));
            }
        }
        for (VtkObject vtkObject : this.pipeLineManager.getLookupTableList().getData()) {
            for (Object object : this.pipeLineManager.getMapperList().getData()) {
                if (((vtkMapper)object.getVtkObject()).GetLookupTable() == null || !((vtkMapper)object.getVtkObject()).GetLookupTable().equals(vtkObject.getVtkObject())) continue;
                this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)object.getMetaData().get("CELL"));
            }
            for (Object object : this.pipeLineManager.getScalarBarList().getData()) {
                if (((vtkScalarBarActor)object.getVtkObject()).GetLookupTable() == null || !((vtkScalarBarActor)object.getVtkObject()).GetLookupTable().equals(vtkObject.getVtkObject())) continue;
                this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)object.getMetaData().get("CELL"));
            }
        }
        for (VtkObject vtkObject : this.pipeLineManager.getFilterList().getData()) {
            for (VtkObject vtkObject2 : this.pipeLineManager.getMapperList().getData()) {
                for (Object object : ((Filter)vtkObject.getVtkObject()).getInputMapper()) {
                    if (!object.equals(vtkObject2.getVtkObject())) continue;
                    this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
                }
                for (Object object : ((Filter)vtkObject.getVtkObject()).getOutputMapper()) {
                    if (!object.equals(vtkObject2.getVtkObject())) continue;
                    this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
                }
            }
            for (VtkObject vtkObject2 : this.pipeLineManager.getActorList().getData()) {
                for (Object object : ((Filter)vtkObject.getVtkObject()).getInputActor()) {
                    if (!object.equals(vtkObject2.getVtkObject())) continue;
                    this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
                }
                for (Object object : ((Filter)vtkObject.getVtkObject()).getOutputActor()) {
                    if (!object.equals(vtkObject2.getVtkObject())) continue;
                    this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
                }
            }
            for (VtkObject vtkObject2 : this.pipeLineManager.getDataSetList().getData()) {
                for (Object object : ((Filter)vtkObject.getVtkObject()).getInputDataSet()) {
                    if (!object.equals(vtkObject2.getVtkObject())) continue;
                    this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
                }
                for (Object object : ((Filter)vtkObject.getVtkObject()).getOutputDataSet()) {
                    if (!object.equals(vtkObject2.getVtkObject())) continue;
                    this.connect((Cell)vtkObject.getMetaData().get("CELL"), (Cell)vtkObject2.getMetaData().get("CELL"));
                }
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent listDataEvent) {
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    @Override
    public void intervalRemoved(ListDataEvent listDataEvent) {
        VtkObjectCellAdapter vtkObjectCellAdapter = null;
        Object[] objectArray = this.getCellList().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            vtkObjectCellAdapter = (VtkObjectCellAdapter)objectArray[i];
            if (this.pipeLineManager.getVtkObject(vtkObjectCellAdapter.getVtkObject().getId()) != null) continue;
            Iterator iterator = this.viewListenerList.iterator();
            while (iterator.hasNext()) {
                ((GraphViewListener)iterator.next()).removeCell((Cell)vtkObjectCellAdapter);
            }
            this.getCellList().remove(vtkObjectCellAdapter);
        }
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    public void connectivityChange(VtkObject vtkObject) {
        this.updateConnection();
        this.reload();
    }

    public PipeLineManager getPipelineManager() {
        return this.pipeLineManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }
}

