/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.VtkObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkPipeLineGraphModel;
import com.artenum.cassandra.ui.VtkObjectPopupMenuDipatcher;
import com.artenum.graph.SimpleGraphPanel;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import com.artenum.graph.interfaces.GraphModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

public class VtkPipeLinePanel
extends SimpleGraphPanel
implements Observer {
    private VtkObjectPopupMenuDipatcher vtkPopupMenu;
    private PopupListener popupListener;
    private Hashtable cellIndex;
    private Stroke lineStroke;

    public VtkPipeLinePanel(VtkPipeLineGraphModel vtkPipeLineGraphModel) {
        super((GraphModel)vtkPipeLineGraphModel);
        ((Observable)vtkPipeLineGraphModel.getPipelineManager()).addObserver(this);
        this.vtkPopupMenu = new VtkObjectPopupMenuDipatcher(vtkPipeLineGraphModel.getPipelineManager(), vtkPipeLineGraphModel.getPluginManager());
        this.popupListener = new PopupListener();
        this.cellIndex = new Hashtable();
        this.setBackground(Color.WHITE);
        this.lineStroke = new BasicStroke(2.0f);
        this.enableGroupSelection(true);
        this.enableGroupDragging(true);
    }

    public void addCell(Cell cell) {
        this.cellIndex.put(cell.getUI(), cell);
        Component component = cell.getUI();
        Point point = ((VtkObjectCellAdapter)cell).getPosition();
        cell.addGroupDragListener((Object)this.groupDragListener);
        this.add(component);
        component.addMouseListener(this.popupListener);
        component.setBounds(new Rectangle(component.getPreferredSize()));
        component.setLocation(point.x, point.y);
        this.validate();
        this.repaint();
    }

    protected void drawConnection(Graphics graphics, Connection connection) {
        Point point = connection.getSource().getConnectionPoint(connection);
        Point point2 = connection.getTarget().getConnectionPoint(connection);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(Color.BLACK);
        graphics2D.setStroke(this.lineStroke);
        graphics2D.drawLine(point.x, point.y, point2.x, point2.y);
    }

    @Override
    public void update(Observable observable, Object object) {
        this.repaint();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                VtkObject vtkObject = ((VtkObjectCellAdapter)VtkPipeLinePanel.this.cellIndex.get(mouseEvent.getSource())).getVtkObject();
                VtkPipeLinePanel.this.vtkPopupMenu.showPopupMenu(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY(), vtkObject);
            }
        }
    }
}

