/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import vtk.vtkActor;
import vtk.vtkCutter;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkImplicitFunction;
import vtk.vtkMapper;
import vtk.vtkPlane;
import vtk.vtkPolyDataMapper;

public class CuttingPlanePipeLine {
    private vtkDataSet dataset;
    private vtkPolyDataMapper mapper;
    private vtkActor actor;
    private double nx;
    private double ny;
    private double nz;
    private double cx;
    private double cy;
    private double cz;
    private vtkPlane plane;
    private vtkCutter planeCut;

    public CuttingPlanePipeLine(vtkDataSet vtkDataSet2, double d, double d2, double d3, double d4, double d5, double d6) {
        this.dataset = vtkDataSet2;
        this.nx = d;
        this.ny = d2;
        this.nz = d3;
        this.cx = d4;
        this.cy = d5;
        this.cz = d6;
        this.plane = new vtkPlane();
        this.plane.SetOrigin(d4, d5, d6);
        this.plane.SetNormal(d, d2, d3);
        this.planeCut = new vtkCutter();
        this.planeCut.SetCutFunction((vtkImplicitFunction)this.plane);
        this.planeCut.SetInput((vtkDataObject)vtkDataSet2);
        this.mapper = new vtkPolyDataMapper();
        this.mapper.SetInput(this.planeCut.GetOutput());
        this.mapper.SetScalarRange(vtkDataSet2.GetPointData().GetScalars().GetRange());
        this.actor = new vtkActor();
        this.actor.SetMapper((vtkMapper)this.mapper);
        vtkDataSet2.Update();
    }

    public void setNormal(double d, double d2, double d3) {
        this.nx = d;
        this.ny = d2;
        this.nz = d3;
        this.plane.SetNormal(d, d2, d3);
        this.planeCut.Update();
    }

    public void setOrigine(double d, double d2, double d3) {
        this.cx = d;
        this.cy = d2;
        this.cz = d3;
        this.plane.SetOrigin(d, d2, d3);
        this.planeCut.Update();
    }

    public void updatePipeLine() {
        this.dataset.Update();
    }

    public vtkActor getActor() {
        return this.actor;
    }

    public vtkDataSet getDataset() {
        return this.dataset;
    }

    public vtkMapper getMapper() {
        return this.mapper;
    }
}

