/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.IsoLevelPipeLine;
import java.util.ArrayList;
import vtk.vtkDataSet;
import vtk.vtkProp;

public class IsoLevelAnimation
extends Thread {
    private vtkDataSet dataset;
    private ArrayList list;
    private boolean keepGoing = true;
    private PipeLineManager pipeLineManager;
    private int speed = 100;
    private double reduction = 0.25;
    private double stepSize;

    public IsoLevelAnimation(PipeLineManager pipeLineManager, vtkDataSet vtkDataSet2, double d, double d2, int n, boolean bl, boolean bl2) {
        this.dataset = vtkDataSet2;
        this.pipeLineManager = pipeLineManager;
        this.list = new ArrayList();
        this.stepSize = (d2 - d) / (double)n;
        for (int i = 0; i < n; ++i) {
            IsoLevelPipeLine isoLevelPipeLine = new IsoLevelPipeLine(vtkDataSet2, d + (double)i * this.stepSize, bl);
            if (bl2) {
                pipeLineManager.setActorVisible(pipeLineManager.addActor((Object)isoLevelPipeLine.getActor(), "Slice actor"), true);
            } else {
                pipeLineManager.getCassandraView().GetRenderer().AddActor((vtkProp)isoLevelPipeLine.getActor());
            }
            this.list.add(isoLevelPipeLine);
        }
        this.setPriority(1);
    }

    @Override
    public void run() {
        IsoLevelPipeLine isoLevelPipeLine3 = null;
        IsoLevelPipeLine isoLevelPipeLine2 = null;
        ArrayList<IsoLevelPipeLine> arrayList = new ArrayList<IsoLevelPipeLine>();
        while (this.keepGoing) {
            for (IsoLevelPipeLine isoLevelPipeLine3 : this.list) {
                arrayList.add(isoLevelPipeLine3);
                isoLevelPipeLine3.getActor().SetVisibility(1);
                if (isoLevelPipeLine2 != null) {
                    isoLevelPipeLine2.getActor().SetVisibility(0);
                }
                isoLevelPipeLine2 = isoLevelPipeLine3;
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    IsoLevelAnimation.sleep(this.speed);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("sleep error");
                }
            }
            while (!arrayList.isEmpty()) {
                isoLevelPipeLine3 = (IsoLevelPipeLine)arrayList.remove(arrayList.size() - 1);
                isoLevelPipeLine3.getActor().SetVisibility(1);
                if (isoLevelPipeLine2 != null) {
                    isoLevelPipeLine2.getActor().SetVisibility(0);
                }
                isoLevelPipeLine2 = isoLevelPipeLine3;
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    IsoLevelAnimation.sleep(this.speed);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("sleep error");
                }
            }
        }
    }

    public void stopWorking() {
        this.keepGoing = false;
    }

    public void setSpeed(int n) {
        this.speed = n;
    }

    public void setReduction(double d) {
        this.reduction = d;
    }
}

