/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.vtk;

import com.artenum.cassandra.vtk.PickingObserver;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import vtk.vtkAbstractPicker;
import vtk.vtkCamera;
import vtk.vtkCanvas;
import vtk.vtkDataObject;
import vtk.vtkGenericRenderWindowInteractor;
import vtk.vtkInteractorObserver;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkJPEGWriter;
import vtk.vtkPNGWriter;
import vtk.vtkPointPicker;
import vtk.vtkTIFFWriter;
import vtk.vtkWindow;
import vtk.vtkWindowToImageFilter;

public class CassandraView
extends vtkCanvas
implements KeyListener {
    private static final long serialVersionUID = 1L;
    private double zoomFactor = 0.1;
    private boolean deepValidation = true;
    private vtkPointPicker pointPicker = new vtkPointPicker();
    private ArrayList pickingObservers;

    public CassandraView() {
        this.pointPicker.SetTolerance(0.005);
        vtkInteractorStyleTrackballCamera vtkInteractorStyleTrackballCamera2 = new vtkInteractorStyleTrackballCamera();
        this.getInteractor().SetInteractorStyle((vtkInteractorObserver)vtkInteractorStyleTrackballCamera2);
        this.getInteractor().SetPicker((vtkAbstractPicker)this.pointPicker);
        this.pickingObservers = new ArrayList();
        this.pointPicker.AddObserver("EndPickEvent", (Object)this, "pick");
    }

    public void addPickingObserver(PickingObserver pickingObserver) {
        this.pickingObservers.add(pickingObserver);
    }

    public void removePickingObserver(PickingObserver pickingObserver) {
        this.pickingObservers.remove(pickingObserver);
    }

    public void removePickingObserver(int n) {
        this.pickingObservers.remove(n);
    }

    public void pick() {
        PickingObserver pickingObserver2 = null;
        if (this.pointPicker.GetPointId() > 0) {
            for (PickingObserver pickingObserver2 : this.pickingObservers) {
                pickingObserver2.pick(this.pointPicker);
            }
        }
    }

    public vtkPointPicker getPointPicker() {
        return this.pointPicker;
    }

    public void setZoomFactor(double d) {
        this.zoomFactor = d;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    public void setXYView() {
        this.setCameraPosition(0.0, 0.0, this.ren.GetActiveCamera().GetDistance(), 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setYZView() {
        this.setCameraPosition(this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0, 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    public void setXZView() {
        this.setCameraPosition(0.0, this.ren.GetActiveCamera().GetDistance(), 0.0, 0.0);
        this.UpdateLight();
        this.resetCamera();
    }

    protected void setCameraPosition(double d, double d2, double d3, double d4) {
        this.ren.GetActiveCamera().SetPosition(d, d2, d3);
        this.ren.GetActiveCamera().SetRoll(d4);
    }

    public void setBackground(Color color) {
        double d = (float)color.getRed() / 255.0f;
        double d2 = (float)color.getGreen() / 255.0f;
        double d3 = (float)color.getBlue() / 255.0f;
        this.GetRenderer().SetBackground(d, d2, d3);
    }

    public void setAmbiantLight(Color color) {
        double d = (float)color.getRed() / 255.0f;
        double d2 = (float)color.getGreen() / 255.0f;
        double d3 = (float)color.getBlue() / 255.0f;
        this.GetRenderer().SetAmbient(d, d2, d3);
    }

    public void resetCamera() {
        super.resetCamera();
    }

    public void zoom(double d) {
        vtkCamera vtkCamera2 = this.GetRenderer().GetActiveCamera();
        if (vtkCamera2.GetParallelProjection() == 1) {
            vtkCamera2.SetParallelScale(vtkCamera2.GetParallelScale() / d);
        } else {
            vtkCamera2.Dolly(d);
            this.resetCameraClippingRange();
        }
    }

    public void rotate(double d, double d2) {
        vtkCamera vtkCamera2 = this.GetRenderer().GetActiveCamera();
        vtkCamera2.Azimuth(d);
        vtkCamera2.Elevation(d2);
        vtkCamera2.OrthogonalizeViewUp();
        this.resetCameraClippingRange();
        if (this.LightFollowCamera == 1) {
            this.lgt.SetPosition(vtkCamera2.GetPosition());
            this.lgt.SetFocalPoint(vtkCamera2.GetFocalPoint());
        }
    }

    public synchronized void deepValidateView() {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
            this.Render();
            this.invalidate();
            this.validate();
            this.repaint();
        } else {
            this.repaint();
        }
        Dimension dimension = this.getPreferredSize();
        if (!this.getSize().equals(dimension)) {
            this.setSize(1, 1);
            this.setSize(dimension);
            this.invalidate();
            this.validate();
            this.repaint();
        } else if (this.deepValidation) {
            this.deepValidation = false;
            this.setSize(1, 1);
            this.setSize(dimension);
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    public void validateViewAndWait() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                        CassandraView.this.Render();
                        CassandraView.this.invalidate();
                        CassandraView.this.validate();
                        CassandraView.this.repaint();
                    } else {
                        CassandraView.this.repaint();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void validateViewAndGo() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (System.getProperty("os.name").toLowerCase().indexOf("win") == -1) {
                        CassandraView.this.Render();
                        CassandraView.this.invalidate();
                        CassandraView.this.validate();
                        CassandraView.this.repaint();
                    } else {
                        CassandraView.this.repaint();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 73) {
            this.zoom(1.0 + this.zoomFactor);
        } else if (keyEvent.getKeyCode() == 79) {
            this.zoom(1.0 - this.zoomFactor);
        } else if (keyEvent.getKeyCode() == 38) {
            this.rotate(0.0, -1.0);
        } else if (keyEvent.getKeyCode() == 40) {
            this.rotate(0.0, 1.0);
        } else if (keyEvent.getKeyCode() == 37) {
            this.rotate(1.0, 0.0);
        } else if (keyEvent.getKeyCode() == 39) {
            this.rotate(-1.0, 0.0);
        } else {
            super.keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        super.keyReleased(keyEvent);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        super.keyTyped(keyEvent);
    }

    public synchronized void saveToPNG(String string) {
        this.Lock();
        vtkWindowToImageFilter vtkWindowToImageFilter2 = new vtkWindowToImageFilter();
        vtkWindowToImageFilter2.SetInput((vtkWindow)this.rw);
        vtkWindowToImageFilter2.SetMagnification(1);
        vtkWindowToImageFilter2.Update();
        vtkPNGWriter vtkPNGWriter2 = new vtkPNGWriter();
        vtkPNGWriter2.SetInput((vtkDataObject)vtkWindowToImageFilter2.GetOutput());
        vtkPNGWriter2.SetFileName(string);
        vtkPNGWriter2.Write();
        this.UnLock();
    }

    public synchronized void saveToJPG(String string) {
        this.Lock();
        vtkWindowToImageFilter vtkWindowToImageFilter2 = new vtkWindowToImageFilter();
        vtkWindowToImageFilter2.SetInput((vtkWindow)this.rw);
        vtkWindowToImageFilter2.SetMagnification(1);
        vtkWindowToImageFilter2.Update();
        vtkJPEGWriter vtkJPEGWriter2 = new vtkJPEGWriter();
        vtkJPEGWriter2.SetInput((vtkDataObject)vtkWindowToImageFilter2.GetOutput());
        vtkJPEGWriter2.SetFileName(string);
        vtkJPEGWriter2.Write();
        this.UnLock();
    }

    public synchronized void saveToTIFF(String string) {
        this.Lock();
        vtkWindowToImageFilter vtkWindowToImageFilter2 = new vtkWindowToImageFilter();
        vtkWindowToImageFilter2.SetInput((vtkWindow)this.rw);
        vtkWindowToImageFilter2.SetMagnification(1);
        vtkWindowToImageFilter2.Update();
        vtkTIFFWriter vtkTIFFWriter2 = new vtkTIFFWriter();
        vtkTIFFWriter2.SetInput((vtkDataObject)vtkWindowToImageFilter2.GetOutput());
        vtkTIFFWriter2.SetFileName(string);
        vtkTIFFWriter2.Write();
        this.UnLock();
    }

    public vtkGenericRenderWindowInteractor getInteractor() {
        return this.getIren();
    }
}

