/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.vtk;

import com.artenum.cassandra.pipeline.SimplePipeLineManager;
import vtk.vtkActor;
import vtk.vtkAssembly;
import vtk.vtkAxes;
import vtk.vtkConeSource;
import vtk.vtkDataObject;
import vtk.vtkMapper;
import vtk.vtkPolyDataMapper;
import vtk.vtkProp;
import vtk.vtkProp3D;
import vtk.vtkTextActor;
import vtk.vtkTubeFilter;

public class DefaultAxes {
    private double axisLength = 0.8;
    private double axisTextLength = 1.2;
    private SimplePipeLineManager pipelineManager;
    private vtkTextActor xactor;
    private vtkTextActor yactor;
    private vtkTextActor zactor;
    private vtkConeSource xcone;
    private vtkConeSource ycone;
    private vtkConeSource zcone;
    private vtkAssembly assembly;

    public DefaultAxes(SimplePipeLineManager simplePipeLineManager) {
        this.pipelineManager = simplePipeLineManager;
        vtkAxes vtkAxes2 = new vtkAxes();
        vtkAxes2.SetOrigin(0.0, 0.0, 0.0);
        vtkAxes2.SetScaleFactor(this.axisLength);
        this.xactor = new vtkTextActor();
        this.yactor = new vtkTextActor();
        this.zactor = new vtkTextActor();
        this.xactor.SetInput("X");
        this.yactor.SetInput("Y");
        this.zactor.SetInput("Z");
        this.xactor.ScaledTextOn();
        this.yactor.ScaledTextOn();
        this.zactor.ScaledTextOn();
        this.xactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.yactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.zactor.GetPositionCoordinate().SetCoordinateSystemToWorld();
        this.xactor.GetPositionCoordinate().SetValue(this.axisLength, 0.0, 0.0);
        this.yactor.GetPositionCoordinate().SetValue(0.0, this.axisLength, 0.0);
        this.zactor.GetPositionCoordinate().SetValue(0.0, 0.0, this.axisLength);
        this.xactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.xactor.GetTextProperty().ShadowOn();
        this.xactor.GetTextProperty().ItalicOn();
        this.xactor.GetTextProperty().BoldOff();
        this.yactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.yactor.GetTextProperty().ShadowOn();
        this.yactor.GetTextProperty().ItalicOn();
        this.yactor.GetTextProperty().BoldOff();
        this.zactor.GetTextProperty().SetColor(1.0, 1.0, 1.0);
        this.zactor.GetTextProperty().ShadowOn();
        this.zactor.GetTextProperty().ItalicOn();
        this.zactor.GetTextProperty().BoldOff();
        this.xactor.SetMaximumLineHeight(0.25);
        this.yactor.SetMaximumLineHeight(0.25);
        this.zactor.SetMaximumLineHeight(0.25);
        vtkTubeFilter vtkTubeFilter2 = new vtkTubeFilter();
        vtkTubeFilter2.SetInput((vtkDataObject)vtkAxes2.GetOutput());
        vtkTubeFilter2.SetRadius(0.05);
        vtkTubeFilter2.SetNumberOfSides(8);
        vtkPolyDataMapper vtkPolyDataMapper2 = new vtkPolyDataMapper();
        vtkPolyDataMapper2.SetInput(vtkTubeFilter2.GetOutput());
        vtkActor vtkActor2 = new vtkActor();
        vtkActor2.SetMapper((vtkMapper)vtkPolyDataMapper2);
        vtkActor2.PickableOff();
        int n = 12;
        double d = 0.3;
        this.xcone = new vtkConeSource();
        this.xcone.SetResolution(n);
        vtkPolyDataMapper vtkPolyDataMapper3 = new vtkPolyDataMapper();
        vtkPolyDataMapper3.SetInput(this.xcone.GetOutput());
        vtkActor vtkActor3 = new vtkActor();
        vtkActor3.SetMapper((vtkMapper)vtkPolyDataMapper3);
        vtkActor3.GetProperty().SetColor(1.0, 0.0, 0.0);
        vtkActor3.SetScale(d, d, d);
        vtkActor3.SetPosition(this.axisLength, 0.0, 0.0);
        this.ycone = new vtkConeSource();
        this.ycone.SetResolution(n);
        vtkPolyDataMapper vtkPolyDataMapper4 = new vtkPolyDataMapper();
        vtkPolyDataMapper4.SetInput(this.ycone.GetOutput());
        vtkActor vtkActor4 = new vtkActor();
        vtkActor4.SetMapper((vtkMapper)vtkPolyDataMapper4);
        vtkActor4.GetProperty().SetColor(1.0, 1.0, 0.0);
        vtkActor4.RotateZ(90.0);
        vtkActor4.SetScale(d, d, d);
        vtkActor4.SetPosition(0.0, this.axisLength, 0.0);
        this.zcone = new vtkConeSource();
        this.zcone.SetResolution(n);
        vtkPolyDataMapper vtkPolyDataMapper5 = new vtkPolyDataMapper();
        vtkPolyDataMapper5.SetInput(this.zcone.GetOutput());
        vtkActor vtkActor5 = new vtkActor();
        vtkActor5.SetMapper((vtkMapper)vtkPolyDataMapper5);
        vtkActor5.GetProperty().SetColor(0.0, 1.0, 0.0);
        vtkActor5.RotateY(-90.0);
        vtkActor5.SetScale(d, d, d);
        vtkActor5.SetPosition(0.0, 0.0, this.axisLength);
        this.assembly = new vtkAssembly();
        this.assembly.AddPart((vtkProp3D)vtkActor2);
        this.assembly.AddPart((vtkProp3D)vtkActor3);
        this.assembly.AddPart((vtkProp3D)vtkActor4);
        this.assembly.AddPart((vtkProp3D)vtkActor5);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.pipelineManager.getCassandraView().GetRenderer().AddActor2D((vtkProp)this.xactor);
            this.pipelineManager.getCassandraView().GetRenderer().AddActor2D((vtkProp)this.yactor);
            this.pipelineManager.getCassandraView().GetRenderer().AddActor2D((vtkProp)this.zactor);
            this.pipelineManager.getCassandraView().GetRenderer().AddActor((vtkProp)this.assembly);
        } else {
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor2D((vtkProp)this.xactor);
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor2D((vtkProp)this.yactor);
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor2D((vtkProp)this.zactor);
            this.pipelineManager.getCassandraView().GetRenderer().RemoveActor((vtkProp)this.assembly);
        }
    }
}

