import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.border.Border;

import vtk.vtkActor;
import vtk.vtkCone;
import vtk.vtkConeSource;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkJPEGReader;
import vtk.vtkLookupTable;
import vtk.vtkPanel;
import vtk.vtkPlane;
import vtk.vtkPlaneSource;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkScalarBarActor;
import vtk.vtkTexture;

public class Test5 {
	public static void main(String[] args) {
		
		vtkPanel panel = new vtkPanel();
		
		vtkJPEGReader reader = new vtkJPEGReader();
		reader.SetFileName("/home/vtk/Desktop/images.jpg");
		
		vtkTexture texture = new vtkTexture();
		texture.SetInput(reader.GetOutput());
		
		vtkDataSetReader vrd = new vtkDataSetReader();
		vrd.SetFileName("/home/vtk/Desktop/imageData.vtk");
		vrd.Update();
		vrd.CloseVTKFile();
		
		vtkPlaneSource planeSource = new vtkPlaneSource();
		
		
		vtkDataSetMapper vdm = new vtkDataSetMapper();
		vdm.SetInput(planeSource.GetOutput());
		//vdm.SetScalarRange(vrd.GetOutput().GetScalarRange());
		//vdm.SetScalarVisibility(0);
		
		vtkActor va = new vtkActor();
		va.SetMapper(vdm);
		va.SetTexture(texture);
		panel.GetRenderer().AddActor(va);
		//va.GetProperty().SetInterpolationToFlat();
		
		vtkLookupTable lookupTable = new vtkLookupTable();
		lookupTable.SetRange(vrd.GetOutput().GetScalarRange());
		//vdm.SetLookupTable(lookupTable);
		lookupTable.SetHueRange(0.6666,0);
		
		vtkScalarBarActor barActor = new vtkScalarBarActor();
		barActor.SetLookupTable(lookupTable);
		
		//panel.GetRenderer().AddActor2D(barActor);
		
		JFrame f = new JFrame("é");
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setSize(300, 300);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
		
	}
}
