import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.border.Border;

import vtk.vtkActor;
import vtk.vtkCone;
import vtk.vtkConeSource;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkPanel;
import vtk.vtkPlane;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;
import vtk.vtkScalarBarActor;

public class Test2 {
	public static void main(String[] args) {
		
		vtkPanel panel = new vtkPanel();

//		vtkConeSource vcs = new vtkConeSource();
		
		vtkDataSetReader vrd = new vtkDataSetReader();
		vrd.SetFileName("/home/vtk/Desktop/imageData.vtk");
		vrd.Update();
		vrd.CloseVTKFile();
		
		
		/*vtkContourFilter vcf = new vtkContourFilter();
		vcf.GenerateValues(10, vrd.GetOutput().GetScalarRange());
		vcf.SetInput(vrd.GetOutput());*/
		
		
		vtkCutter cutter = new vtkCutter();
		vtkPlane plane = new vtkPlane();
		cutter.SetCutFunction(plane);
		cutter.SetInput(vrd.GetOutput());
		
		vtkDataSetMapper vdm = new vtkDataSetMapper();
		//vdm.SetInput(vcf.GetOutput());
		vdm.SetInput(cutter.GetOutput());
		cutter.GetOutput().Update();
		vdm.SetScalarRange(cutter.GetOutput().GetScalarRange());
		
		vtkActor va = new vtkActor();
		va.SetMapper(vdm);
		panel.GetRenderer().AddActor(va);
		va.GetProperty().SetInterpolationToFlat();
		
		
		
		vtkLookupTable lookupTable = new vtkLookupTable();
		lookupTable.SetRange(vrd.GetOutput().GetScalarRange());
		vdm.SetLookupTable(lookupTable);
		lookupTable.SetHueRange(0.6666,0);
		
		vtkScalarBarActor barActor = new vtkScalarBarActor();
		barActor.SetLookupTable(lookupTable);
		
		
		
		
		panel.GetRenderer().AddActor2D(barActor);
		
		JFrame f = new JFrame("é");
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setSize(300, 300);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
		
	}
}
