import java.awt.BorderLayout;

import javax.swing.JFrame;

import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkPanel;

public class testVtk1 {

	public static void main(String[] args) {

		vtkPanel panel = new vtkPanel();

		vtkConeSource cone = new vtkConeSource();
		cone.SetHeight(3.0);
		cone.SetRadius(1.0);
		cone.SetResolution(10);

		vtkDataSetReader demo = new vtkDataSetReader();
		demo.SetFileName("/home/vtk/demo.vtk");
		demo.Update();
		demo.CloseVTKFile();

		vtkDataSetMapper coneMapper = new vtkDataSetMapper();
		coneMapper.SetInput(cone.GetOutput());

		vtkDataSetMapper demoMapper = new vtkDataSetMapper();
		demoMapper.SetInput(demo.GetOutput());

		vtkActor actor = new vtkActor();
		actor.SetMapper(coneMapper);

		vtkActor actor2 = new vtkActor();
		actor2.SetMapper(demoMapper);

		panel.GetRenderer().AddActor(actor);
		panel.GetRenderer().AddActor(actor2);

		//
		JFrame f = new JFrame("");
		f.getContentPane().setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setSize(300, 300);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

}
