import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkDataSet;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkInteractorStyleTrackball;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkPanel;
import vtk.vtkRenderWindow;
import vtk.vtkRenderWindowInteractor;
import vtk.vtkRenderer;


public class testVtk2 {

public static void main(String[] args) {
	
	System.loadLibrary("vtkCommonJava");
	System.loadLibrary("vtkFilteringJava");
	System.loadLibrary("vtkIOJava");
	System.loadLibrary("vtkImagingJava");
	System.loadLibrary("vtkGraphicsJava");
	System.loadLibrary("vtkRenderingJava");
	System.loadLibrary("vtkHybridJava");
	
	vtkConeSource cone = new vtkConeSource();
	cone.SetHeight(3.0);
	cone.SetRadius(1.0);
	cone.SetResolution(10);
	
	vtkDataSetReader demo = new vtkDataSetReader();
	demo.SetFileName("/home/vtk/demo.vtk");
	demo.Update();
	demo.CloseVTKFile();
	
	
	vtkDataSetMapper coneMapper = new vtkDataSetMapper();
	coneMapper.SetInput(cone.GetOutput());
	
	vtkDataSetMapper demoMapper = new vtkDataSetMapper();
	demoMapper.SetInput(demo.GetOutput());
	
	vtkActor actor = new vtkActor();
	actor.SetMapper(coneMapper);
	
	vtkActor actor2 = new vtkActor();
	actor2.SetMapper(demoMapper);
	
	vtkRenderer renderer = new vtkRenderer();
	vtkRenderWindow rendWin = new vtkRenderWindow();
	rendWin.AddRenderer(renderer);
	
	vtkRenderWindowInteractor iren = new vtkRenderWindowInteractor();
	iren.SetRenderWindow(rendWin);
	
	vtkInteractorStyleTrackballCamera style = new vtkInteractorStyleTrackballCamera();
	iren.SetInteractorStyle(style);
	
	renderer.AddActor(actor);
	renderer.AddActor(actor2);
	
	rendWin.SetSize(300,300);
	rendWin.Render();
	iren.Start();
}	

}
