import vtk.vtkMath;
import vtk.vtkPointSet;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkProgrammableFilter;
import vtk.vtkStructuredGrid;


public class MyFilter extends vtkProgrammableFilter {

	private int param_step;
	private double[] param_vector;
	
	@SuppressWarnings("unused")
	private void executeFilter() {
	 	vtkPolyData input_struct = GetPolyDataInput();
	 	vtkPolyData out_struct = GetPolyDataOutput();
	 	// init out
	 	out_struct.CopyStructure(input_struct);
	 	out_struct.GetPointData().PassData(input_struct.GetPointData());
	 	out_struct.GetCellData().PassData(input_struct.GetCellData());
	 	out_struct.SetPoints(input_struct.GetPoints());
	 	
	 	vtkPoints points = out_struct.GetPoints();
	 	int numberOfPoints = points.GetNumberOfPoints();
	 	double[] cur_point, new_point = {0, 0, 0};
	 	
	 	for (int i = 0; i < numberOfPoints; ++i)  {
	 		if (i % param_step == 0) {
	 			cur_point = input_struct.GetPoint(i);
	 			vtkMath m = new vtkMath();
	 			m.Cross(cur_point, param_vector, new_point);
	 			out_struct.GetPoints().SetPoint(i, new_point);
	 		}
	 	}
 		
	}
	 	
	public void setStep(int step) {
		param_step = step;
	}
	
	public void setVector(double[] v) {
		param_vector = v;
	}

	public MyFilter() {
		SetExecuteMethod(this, "executeFilter");
	}
	
}
