import java.awt.BorderLayout;

import javax.swing.JFrame;

import vtk.vtkActor;
import vtk.vtkConeSource;
import vtk.vtkContourFilter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkLookupTable;
import vtk.vtkPanel;

public class testVtk3 {

	public static void main(String[] args) {

		vtkPanel panel = new vtkPanel();

		vtkDataSetReader demo = new vtkDataSetReader();
		demo.SetFileName("/home/vtk/imagedata.vtk");
		demo.Update();
		demo.CloseVTKFile();
		
		// get range 
		double[] range = demo.GetOutput().GetScalarRange();
		
		//filter
		vtkContourFilter filter = new vtkContourFilter();
		filter.GenerateValues(10, range);
				
		filter.SetInputConnection(demo.GetOutputPort());
		
		//LookupeTable
		vtkLookupTable ltable = new vtkLookupTable();
		ltable.SetHueRange(0,0.6667);
		ltable.Build();
		
		// mapper
		vtkDataSetMapper demoMapper = new vtkDataSetMapper();
		demoMapper.SetInputConnection(filter.GetOutputPort());
		demoMapper.SetLookupTable(ltable);
		demoMapper.SetScalarRange(range);

		vtkActor actor2 = new vtkActor();
		actor2.SetMapper(demoMapper);

		panel.GetRenderer().AddActor(actor2);

		//
		JFrame f = new JFrame("");
		f.getContentPane().setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setDefaultCloseOperation(1);
		f.setSize(800, 800);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
	}

}
