import java.awt.BorderLayout;

import javax.swing.JFrame;

import vtk.vtk3DWidget;
import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkCanvas;
import vtk.vtkCone;
import vtk.vtkConeSource;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkDelaunay2D;
import vtk.vtkImplicitPlaneWidget;
import vtk.vtkInteractorStyleTrackball;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkLODActor;
import vtk.vtkLookupTable;
import vtk.vtkObject;
import vtk.vtkPanel;
import vtk.vtkPlane;
import vtk.vtkRenderer;
import vtk.vtkScalarBarActor;
import vtk.vtkWarpScalar;

public class testVtk5 {
	
	//filter
	vtkPlane plane2=null;
	vtkImplicitPlaneWidget widget =null;
	vtkWarpScalar wrap =null;
	public testVtk5()
	{

		vtkCanvas panel = new vtkCanvas();
		vtkInteractorStyleTrackballCamera inter=new vtkInteractorStyleTrackballCamera();
		panel.getIren().SetInteractorStyle(inter);
		
		
		vtkDataSetReader plasma = new vtkDataSetReader();
		plasma.SetFileName("/home/vtk/Desktop/Cassandra-2.2-linux64/Data/Sat-Plasma/plasma.vtk");
		plasma.Update();
		plasma.CloseVTKFile();
		
		vtkDataSetMapper map = new vtkDataSetMapper();
		map.SetInput(plasma.GetOutput());
		vtkActor plasmaAct = new vtkActor();
		plasmaAct.SetMapper(map);
		map.Update();
		
		// get range source data
		double[] range = plasma.GetOutput().GetScalarRange();
		
		plane2=new vtkPlane();
		widget= new vtkImplicitPlaneWidget();

		
		//LookupeTable
		vtkLookupTable ltable = new vtkLookupTable();
		ltable.SetHueRange(0.6667, 0);
		ltable.Build();
		
		// demomapper actor 
		vtkActor actor2 = new vtkLODActor();
		
	    // filter
		vtkCutter filter = new vtkCutter();
		filter.SetInputConnection(plasma.GetOutputPort());
		filter.SetCutFunction(plane2);
		
		
		wrap = new vtkWarpScalar();
		
		// mapper
		vtkDataSetMapper demoMapper = new vtkDataSetMapper();
		demoMapper.SetInputConnection(wrap.GetOutputPort());
		demoMapper.SetLookupTable(ltable);
		demoMapper.SetScalarRange(range);
		
		actor2.SetMapper(demoMapper);

		// scalar bar actor
		vtkScalarBarActor scalarBar = new vtkScalarBarActor();
		scalarBar.SetLookupTable(ltable);
		
		panel.GetRenderer().AddActor(actor2);
		panel.GetRenderer().AddActor2D(scalarBar);
		

		
		// widget
		widget.SetInteractor(panel.getIren());
		widget.SetPlaceFactor(1);
		widget.SetProp3D(plasmaAct);
		widget.PlaceWidget();
		widget.DrawPlaneOff();
		widget.GetPlane(plane2);
		widget.EnabledOff();
		widget.ScaleEnabledOff();
		widget.AddObserver("InteractionEvent", this, "myCallback");
		widget.On();
		
	    
	    wrap.SetNormal(plane2.GetNormal());
	    wrap.SetScaleFactor(75);
	    wrap.UseNormalOn();
	    wrap.SetInputConnection(filter.GetOutputPort());
		
		JFrame f = new JFrame("");
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.getContentPane().setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setSize(800, 800);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
		//
		panel.getIren().SetSize(panel.getSize().width,panel.getSize().height);
		panel.resetCamera();
				
	}
	
	public void myCallback()
	{
		widget.GetPlane(plane2);
		wrap.SetNormal(plane2.GetNormal());
		
	}

	public static void main(String[] args) {

		new testVtk5();
	}

}
