import java.awt.BorderLayout;
import java.util.Arrays;

import javax.swing.JFrame;

import vtk.vtkActor;
import vtk.vtkActor2D;
import vtk.vtkCanvas;
import vtk.vtkCone;
import vtk.vtkConeSource;
import vtk.vtkContourFilter;
import vtk.vtkCutter;
import vtk.vtkDataSetMapper;
import vtk.vtkDataSetReader;
import vtk.vtkInteractorStyleTrackballCamera;
import vtk.vtkLookupTable;
import vtk.vtkPanel;
import vtk.vtkPicker;
import vtk.vtkPlane;
import vtk.vtkPointPicker;
import vtk.vtkScalarBarActor;

public class testVtk4 {
	
	private vtkPointPicker pick;
	private MyFilter2 filter2;
	
	public testVtk4(){
		vtkCanvas panel = new vtkCanvas();
		panel.getIren().SetInteractorStyle(new vtkInteractorStyleTrackballCamera());

		vtkDataSetReader demo = new vtkDataSetReader();
		demo.SetFileName("/home/vtk/imagedata.vtk");
		demo.Update();
		demo.CloseVTKFile();
		
		// implicit function
		vtkPlane plane = new vtkPlane();
		plane.SetOrigin(1, 1, 1);
		plane.SetNormal(0, 1, 0);	

		//filter
		vtkCutter filter = new vtkCutter();
		filter.SetInputConnection(demo.GetOutputPort());
		filter.SetCutFunction(plane);
		// get range filter
		double[] range_filter =  filter.GetOutput().GetScalarRange();
		
		filter2 = new MyFilter2();
		double[] tmp = {0,0,0};
		filter2.SetInputConnection(filter.GetOutputPort());
		
		
		//LookupeTable
		vtkLookupTable ltable = new vtkLookupTable();
		ltable.SetHueRange(0.6667, 0);
		ltable.Build();
		
		// mapper
		vtkDataSetMapper demoMapper = new vtkDataSetMapper();
		demoMapper.SetInputConnection(filter2.GetOutputPort());
		demoMapper.SetLookupTable(ltable);
		demoMapper.SetScalarRange(range_filter);
		demoMapper.Update();

		// demomapper actor 
		vtkActor actor2 = new vtkActor();
		actor2.SetMapper(demoMapper);

		// scalar bar actor
		vtkScalarBarActor scalarBar = new vtkScalarBarActor();
		scalarBar.SetLookupTable(ltable);
		
		
		panel.GetRenderer().AddActor(actor2);
		panel.GetRenderer().AddActor2D(scalarBar);
		
		//picker
		pick = new vtkPointPicker();
		pick.AddObserver("EndPickEvent", this , "pick");
		panel.getIren().SetPicker(pick);
		
		
		//
		JFrame f = new JFrame("");
		f.getContentPane().setLayout(new BorderLayout());
		f.getContentPane().add(panel, BorderLayout.CENTER);
		f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		f.setSize(800, 800);
		f.setLocationRelativeTo(null);
		f.setVisible(true);
		
		panel.resetCamera();
		
	}
	
	public void pick(){
		System.out.println(Arrays.toString(pick.GetMapperPosition()));
		if(pick.GetPointId() != -1) {
			System.out.println(pick.GetPointId());
			filter2.doPick(pick.GetPointId());
		}
	}

	public static void main(String[] args) {
		new testVtk4();
	}

}
