/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class SingleFaceIteratorFromVertexIds
implements Iterator<Face> {
    private final Mesh mesh;
    private int[] vertexIds;
    private int currentPositionInVertexIds;
    private int currentPositionInFacesOnVertex;
    private Face currentFace;
    private List<Face> currentFacesOnVertex;
    private Set<Integer> alreadyUsedFaceIds;
    private boolean nextDone = true;

    public SingleFaceIteratorFromVertexIds(Mesh mesh, int[] vertexIds) {
        this.mesh = mesh;
        this.vertexIds = vertexIds;
        this.alreadyUsedFaceIds = new TreeSet<Integer>();
        this.currentPositionInVertexIds = 0;
        this.currentPositionInFacesOnVertex = 0;
        if (vertexIds.length != 0) {
            int vertexId = vertexIds[0];
            this.currentFacesOnVertex = this.mesh.getFacesOnVertex(vertexId);
        } else {
            this.currentFacesOnVertex = new ArrayList<Face>();
        }
    }

    @Override
    public boolean hasNext() {
        boolean answer = true;
        boolean stopLoop = false;
        while (!stopLoop) {
            stopLoop = true;
            if (!this.nextDone) continue;
            if (this.currentPositionInVertexIds != this.vertexIds.length - 1) {
                if (this.currentPositionInFacesOnVertex == this.currentFacesOnVertex.size()) {
                    ++this.currentPositionInVertexIds;
                    int vertexId = this.vertexIds[this.currentPositionInVertexIds];
                    this.currentFacesOnVertex = this.mesh.getFacesOnVertex(vertexId);
                    this.currentPositionInFacesOnVertex = 0;
                    if (this.currentFacesOnVertex.size() != 0) {
                        this.currentFace = this.currentFacesOnVertex.get(this.currentPositionInFacesOnVertex);
                    }
                    if (!(stopLoop = this.checkUnicity())) continue;
                    answer = this.confirmValidity();
                    continue;
                }
                this.currentFace = this.currentFacesOnVertex.get(this.currentPositionInFacesOnVertex);
                ++this.currentPositionInFacesOnVertex;
                stopLoop = this.checkUnicity();
                if (!stopLoop) continue;
                answer = this.confirmValidity();
                continue;
            }
            if (this.currentPositionInFacesOnVertex == this.currentFacesOnVertex.size()) {
                this.nextDone = false;
                answer = false;
                continue;
            }
            this.currentFace = this.currentFacesOnVertex.get(this.currentPositionInFacesOnVertex);
            ++this.currentPositionInFacesOnVertex;
            stopLoop = this.checkUnicity();
            if (!stopLoop) continue;
            answer = this.confirmValidity();
        }
        return answer;
    }

    private boolean checkUnicity() {
        boolean stopLoop = true;
        if (this.currentFace != null && this.alreadyUsedFaceIds.contains(this.currentFace.getId())) {
            this.currentFace = null;
            stopLoop = false;
        }
        return stopLoop;
    }

    private boolean confirmValidity() {
        boolean answer;
        if (this.currentFace != null) {
            this.alreadyUsedFaceIds.add(this.currentFace.getId());
            this.nextDone = false;
            answer = true;
        } else {
            this.nextDone = false;
            answer = false;
        }
        return answer;
    }

    @Override
    public Face next() {
        this.nextDone = true;
        return this.currentFace;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    public void clear() {
        this.vertexIds = null;
        this.currentFacesOnVertex.clear();
        this.currentFacesOnVertex = null;
        this.alreadyUsedFaceIds.clear();
        this.alreadyUsedFaceIds = null;
    }
}

