/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import java.awt.Graphics;
import java.awt.Point;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class VtkObjectUI1
extends JLabel
implements VtkObjectUI {
    private CassandraObject object;
    protected Point position;
    protected ImageIcon glassIcon;
    protected int dx;
    protected int dy;

    public VtkObjectUI1(CassandraObject object) {
        String toolTip;
        this.object = object;
        this.position = new Point(10, 10);
        ImageIcon icon = null;
        String txt = toolTip = object.getName();
        if (txt.length() > 6) {
            txt = txt.substring(0, 6);
            txt = txt + "...";
        }
        this.setText(txt);
        this.setToolTipText(toolTip);
        switch (object.getType()) {
            case 1: {
                icon = VtkObjectUI1.createImageIcon("image/actor.png", "Actor");
                this.glassIcon = VtkObjectUI1.createImageIcon("image/eye.png", "Visible");
                this.setIcon(icon);
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 370;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                this.dx = this.getPreferredSize().width / 2 - 12;
                this.dy = 25;
                break;
            }
            case 2: {
                icon = VtkObjectUI1.createImageIcon("image/mapper.png", "Mapper");
                this.setIcon(icon);
                this.setText(" ");
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 250;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                break;
            }
            case 3: {
                icon = VtkObjectUI1.createImageIcon("image/dataset.png", "DataSet");
                this.setIcon(icon);
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 130;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                break;
            }
            case 4: {
                icon = VtkObjectUI1.createImageIcon("image/filter.png", "Filter");
                this.setIcon(icon);
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 10;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                break;
            }
            case 5: {
                icon = VtkObjectUI1.createImageIcon("image/lookupTableLinear.png", "Lookup Table");
                this.setIcon(icon);
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 490;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                break;
            }
            case 6: {
                icon = VtkObjectUI1.createImageIcon("image/scalarBar.png", "ScalarBar");
                this.glassIcon = VtkObjectUI1.createImageIcon("image/eye.png", "Visible");
                this.setIcon(icon);
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 600;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                this.dx = this.getPreferredSize().width / 2 - 15;
                this.dy = 25;
                break;
            }
            case 7: {
                icon = VtkObjectUI1.createImageIcon("image/txtActor.png", "Text actor");
                this.glassIcon = VtkObjectUI1.createImageIcon("image/eye.png", "Visible");
                this.setIcon(icon);
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.position.x = 440;
                this.position.y += (object.getLocalTypeId() - 1) * 120;
                this.dx = this.getPreferredSize().width / 2 - 12;
                this.dy = 25;
            }
        }
    }

    @Override
    public void setName(String newName) {
        this.setText(newName);
    }

    protected static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = VtkObjectCellAdapter.class.getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + imgURL);
        return null;
    }

    public void savePosition() {
        this.position = this.getLocation();
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    public void setPosition(Point p) {
        this.position = p;
        if (this.position.x < 0) {
            this.position.x = 0;
        }
        if (this.position.y < 0) {
            this.position.y = 0;
        }
        this.setLocation(this.position);
    }

    @Override
    public Point getPosition() {
        return this.position;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if ((this.object.getType() == 1 || this.object.getType() == 6 || this.object.getType() == 7) && this.object.getMetaData().get("ACTOR_VISIBLE") != null && ((String)this.object.getMetaData().get("ACTOR_VISIBLE")).equals("true")) {
            g.drawImage(this.glassIcon.getImage(), this.dx, this.dy, this.glassIcon.getImageObserver());
        }
    }
}

