/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkPipeLineGraphModel;
import com.artenum.cassandra.ui.VtkObjectPopupMenuDipatcher;
import com.artenum.graph.SimpleGraphPanel;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.Connection;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;

public class VtkPipeLinePanel
extends SimpleGraphPanel
implements Observer {
    private VtkObjectPopupMenuDipatcher vtkPopupMenu;
    private PopupListener popupListener;
    private Hashtable cellIndex;
    private Stroke lineStroke;

    public VtkPipeLinePanel(VtkPipeLineGraphModel graphModel) {
        super(graphModel);
        ((Observable)((Object)graphModel.getPipelineManager())).addObserver(this);
        this.vtkPopupMenu = new VtkObjectPopupMenuDipatcher(graphModel.getPipelineManager(), graphModel.getPluginManager());
        this.popupListener = new PopupListener();
        this.cellIndex = new Hashtable();
        this.setBackground(Color.WHITE);
        this.lineStroke = new BasicStroke(1.0f);
        this.enableGroupSelection(true);
        this.enableGroupDragging(true);
    }

    @Override
    public void addCell(Cell cell) {
        this.cellIndex.put(cell.getUI(), cell);
        Component c = cell.getUI();
        Point location = ((VtkObjectCellAdapter)cell).getPosition();
        cell.addGroupDragListener(this.groupDragListener);
        this.add(c);
        c.addMouseListener(this.popupListener);
        c.setBounds(new Rectangle(c.getPreferredSize()));
        c.setLocation(location.x, location.y);
        this.validate();
        this.repaint();
    }

    @Override
    protected void drawConnection(Graphics g, Connection connection) {
        Point sourcePoint = connection.getSource().getConnectionPoint(connection);
        Point targetPoint = connection.getTarget().getConnectionPoint(connection);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.BLACK);
        g2.setStroke(this.lineStroke);
        g2.drawLine(sourcePoint.x, sourcePoint.y, targetPoint.x, targetPoint.y);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.repaint();
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                CassandraObject obj = ((VtkObjectCellAdapter)VtkPipeLinePanel.this.cellIndex.get(e.getSource())).getVtkObject();
                VtkPipeLinePanel.this.vtkPopupMenu.showPopupMenu(e.getComponent(), e.getX(), e.getY(), obj);
            }
        }
    }
}

