/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.util.CuttingPlanePipeLine;
import java.util.ArrayList;
import vtk.vtkDataSet;
import vtk.vtkProp;

public class CuttingPlaneAnimation
extends Thread {
    private vtkDataSet dataset;
    private ArrayList list;
    private boolean keepGoing = true;
    private PipeLineManager pipeLineManager;
    private int speed = 100;
    private double reduction = 0.25;

    public CuttingPlaneAnimation(PipeLineManager pipeLineManager, vtkDataSet dataset, double nx, double ny, double nz, double cx, double cy, double cz, int nbPlane, boolean registerActorsInPipe) {
        this.dataset = dataset;
        this.pipeLineManager = pipeLineManager;
        this.list = new ArrayList();
        for (int i = 0; i < nbPlane; ++i) {
            CuttingPlanePipeLine pipe = new CuttingPlanePipeLine(dataset, nx, ny, nz, cx + nx * (double)i, cy + ny * (double)i, cz + nz * (double)i);
            if (registerActorsInPipe) {
                pipeLineManager.setActorVisible(pipeLineManager.addActor(pipe.getActor(), "Slice actor"), true);
            } else {
                pipeLineManager.getCassandraView().GetRenderer().AddActor((vtkProp)pipe.getActor());
            }
            this.list.add(pipe);
        }
        this.setPriority(1);
    }

    @Override
    public void run() {
        CuttingPlanePipeLine currentPipe2 = null;
        CuttingPlanePipeLine tmpPipe2 = null;
        ArrayList<CuttingPlanePipeLine> tmpList = new ArrayList<CuttingPlanePipeLine>();
        while (this.keepGoing) {
            for (CuttingPlanePipeLine currentPipe2 : this.list) {
                tmpList.add(currentPipe2);
                currentPipe2.getActor().GetProperty().SetOpacity(1.0);
                for (CuttingPlanePipeLine tmpPipe2 : this.list) {
                    tmpPipe2.getActor().GetProperty().SetOpacity(tmpPipe2.getActor().GetProperty().GetOpacity() - this.reduction);
                }
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    CuttingPlaneAnimation.sleep(this.speed);
                }
                catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
            while (!tmpList.isEmpty()) {
                currentPipe2 = (CuttingPlanePipeLine)tmpList.remove(tmpList.size() - 1);
                currentPipe2.getActor().GetProperty().SetOpacity(1.0);
                for (CuttingPlanePipeLine tmpPipe2 : this.list) {
                    if (currentPipe2.equals(tmpPipe2)) continue;
                    tmpPipe2.getActor().GetProperty().SetOpacity(tmpPipe2.getActor().GetProperty().GetOpacity() - this.reduction);
                }
                this.pipeLineManager.getCassandraView().repaint();
                try {
                    CuttingPlaneAnimation.sleep(this.speed);
                }
                catch (InterruptedException e) {
                    System.out.println("sleep error");
                }
            }
        }
    }

    public void stopWorking() {
        this.keepGoing = false;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public void setReduction(double reduction) {
        this.reduction = reduction;
    }
}

