/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.plugin.glyph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.FilterImpl;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.RemoveListener;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.plugin.CassandraPlugInProperty;
import com.artenum.cassandra.plugin.CassandraPlugin;
import com.artenum.cassandra.plugin.PlugInControlUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.plugin.SimplePlugInProperty;
import com.artenum.cassandra.plugin.glyph.GlyphControlUI;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import vtk.vtkActor;
import vtk.vtkArrowSource;
import vtk.vtkConeSource;
import vtk.vtkCubeSource;
import vtk.vtkCylinderSource;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkGlyph3D;
import vtk.vtkGlyphSource2D;
import vtk.vtkLineSource;
import vtk.vtkLookupTable;
import vtk.vtkMapper;
import vtk.vtkMaskPoints;
import vtk.vtkObject;
import vtk.vtkPolyDataMapper;
import vtk.vtkScalarBarActor;
import vtk.vtkScalarsToColors;
import vtk.vtkSphereSource;

public class GlyphPlugin
implements CassandraPlugin,
RemoveListener {
    private String name;
    private PipeLineManager pipelineManager;
    private PluginManager pluginManager;
    private JPopupMenu contextualMenu;
    private GlyphControlUI controlUI;
    private vtkDataSet lastDataSet;
    private vtkLookupTable lookupTable;
    private vtkScalarBarActor scalarBar;
    private vtkGlyph3D glyph;
    private vtkPolyDataMapper glyphMapper;
    private vtkActor glyphActor;
    private vtkMaskPoints ptMask;
    private Filter filterImpl;
    private CassandraObject outputCassActor;
    private CassandraObject outputCassMapper;
    private CassandraObject outputCassDataset;
    private CassandraObject outputCassLookupTable;
    private CassandraObject outputCassScalarBar;
    private CassandraObject cassFilter;
    public int maskOnRatio = 1;
    public double scalFactor = 1.0;
    public int resolution = 6;
    private glyph_source sourceType = glyph_source.ARROW3D;
    private glyph_scale_mode scaleMode = glyph_scale_mode.SCALE_VECTOR;
    private glyph_color_mode colorMode = glyph_color_mode.COLOR_VECTOR;
    public static final String PERSISTENCE_KEY_SOURCE_TYPE = "peristence.key.source.type";
    public static final String PERSISTENCE_KEY_INPUT_DATASET = "persistence.key.inputVtkDataSet";
    public static final String PERSISTENCE_KEY_INOUT = "persistence.key.insideOut";
    public static final String PERSISTENCE_KEY_OUPUT_DATASET = "persistence.key.outputDataSet";
    public static final String PERSISTENCE_KEY_OUPUT_MAPPER = "persistence.key.outputMapper";
    public static final String PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE = "persistence.key.outputlookUpTable";
    public static final String PERSISTENCE_KEY_OUTPUT_ACTOR = "persistence.key.outputActor";
    public static final String PERSISTENCE_KEY_OUTPUT_SCALAR_BAR = "persistence.key.ouputScalarBar";
    public static final String PERSISTENCE_KEY_CELL_POS_X = "persistence.key.cell.PosX";
    public static final String PERSISTENCE_KEY_CELL_POS_Y = "persistence.key.cell.PosY";

    public GlyphPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        this.initPipeline();
    }

    public GlyphPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, boolean initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline) {
            this.initPipeline();
        }
    }

    public GlyphPlugin(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner, int initPipeline) {
        this.initPlugIn(pipelineManager, pluginManager, owner);
        if (initPipeline == 1) {
            this.initPipeline();
        }
    }

    public void initPlugIn(PipeLineManager pipelineManager, PluginManager pluginManager, Frame owner) {
        this.name = "3D glyph";
        this.pipelineManager = pipelineManager;
        this.pluginManager = pluginManager;
        this.filterImpl = new FilterImpl();
        this.filterImpl.addRemoveListener((RemoveListener)this);
        this.controlUI = new GlyphControlUI(pipelineManager, this, owner);
        this.contextualMenu = new JPopupMenu("Glyph filter menu");
        JMenuItem showControl = new JMenuItem("Show control");
        showControl.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlyphPlugin.this.controlUI.setVisible(true);
            }
        });
        this.contextualMenu.add(showControl);
        this.contextualMenu.addSeparator();
        JMenuItem remove = new JMenuItem("Remove");
        remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GlyphPlugin.this.remove();
            }
        });
        this.contextualMenu.add(remove);
    }

    public void initPipeline() {
        if (this.ptMask == null) {
            this.ptMask = new vtkMaskPoints();
        }
        this.ptMask.SetOnRatio(this.maskOnRatio);
        this.ptMask.RandomModeOn();
        vtkArrowSource arrowSource = new vtkArrowSource();
        if (this.glyph == null) {
            this.glyph = new vtkGlyph3D();
            this.outputCassDataset = this.pipelineManager.addDataSet((Object)this.glyph.GetOutput(), "Glyph output");
        } else {
            this.outputCassDataset = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.glyph);
        }
        this.glyph.SetInputConnection(this.ptMask.GetOutputPort());
        this.glyph.SetSource(arrowSource.GetOutput());
        this.glyph.SetVectorModeToUseVector();
        this.glyph.SetOrient(1);
        this.glyph.OrientOn();
        this.glyph.SetScaleModeToScaleByVector();
        this.glyph.SetScaleFactor(this.scalFactor);
        if (this.glyphMapper == null) {
            this.glyphMapper = new vtkPolyDataMapper();
            this.outputCassMapper = this.pipelineManager.addMapper((Object)this.glyphMapper, "Glyph");
        } else {
            this.outputCassMapper = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.glyphMapper);
        }
        this.glyphMapper.SetInput(this.glyph.GetOutput());
        if (this.glyphActor == null) {
            this.glyphActor = new vtkActor();
            this.outputCassActor = this.pipelineManager.addActor((Object)this.glyphActor, "Glyph");
        } else {
            this.outputCassActor = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.glyphActor);
        }
        this.glyphActor.SetMapper((vtkMapper)this.glyphMapper);
        if (this.lookupTable == null) {
            this.lookupTable = new vtkLookupTable();
            this.outputCassLookupTable = this.pipelineManager.addLookupTable(this.lookupTable, "Glyph");
        } else {
            this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.lookupTable);
        }
        this.lookupTable.SetHueRange(0.66667, 0.0);
        this.lookupTable.Build();
        this.glyphMapper.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        if (this.scalarBar == null) {
            this.scalarBar = new vtkScalarBarActor();
            this.outputCassScalarBar = this.pipelineManager.addScalarBar(this.scalarBar, "Glyph");
        } else {
            this.outputCassScalarBar = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.scalarBar);
        }
        this.scalarBar.SetLookupTable((vtkScalarsToColors)this.lookupTable);
        this.cassFilter = this.pipelineManager.addFilter(this.filterImpl, "Glyph");
        this.cassFilter.getMetaData().put("POPUP_MENU", this.getContextualMenu());
        this.outputCassActor.setValide(false);
    }

    public void updateGlyph(vtkDataSet vtkDataSet2, glyph_source aSourceType, glyph_scale_mode aScaleMode, glyph_color_mode aColorMode, boolean orientByNormal) {
        if (vtkDataSet2 == null) {
            return;
        }
        this.outputCassActor.setValide(true);
        this.ptMask.SetInputConnection(vtkDataSet2.GetProducerPort());
        this.ptMask.SetOnRatio(this.maskOnRatio);
        this.ptMask.Update();
        if (this.ptMask.GetOutput().GetCellData().GetNumberOfArrays() > 0) {
            this.ptMask.GetOutput().GetCellData().SetVectors(this.ptMask.GetOutput().GetCellData().GetArray(0));
        } else if (this.ptMask.GetOutput().GetPointData().GetNumberOfArrays() > 0) {
            this.ptMask.GetOutput().GetPointData().SetVectors(this.ptMask.GetOutput().GetPointData().GetArray(0));
        }
        this.sourceType = aSourceType;
        switch (aSourceType) {
            default: {
                vtkArrowSource arrowSource = new vtkArrowSource();
                arrowSource.SetShaftResolution(this.resolution);
                arrowSource.SetTipResolution(this.resolution);
                this.glyph.SetSource(arrowSource.GetOutput());
                break;
            }
            case ARROW2D: {
                vtkGlyphSource2D glyph2dArrowsource = new vtkGlyphSource2D();
                glyph2dArrowsource.SetGlyphTypeToArrow();
                glyph2dArrowsource.FilledOff();
                this.glyph.SetSource(glyph2dArrowsource.GetOutput());
                break;
            }
            case BOX: {
                vtkCubeSource cubeSource = new vtkCubeSource();
                this.glyph.SetSource(cubeSource.GetOutput());
                break;
            }
            case CONE: {
                vtkConeSource coneSource = new vtkConeSource();
                coneSource.SetResolution(this.resolution);
                this.glyph.SetSource(coneSource.GetOutput());
                break;
            }
            case CYLINDER: {
                vtkCylinderSource cylinderSource = new vtkCylinderSource();
                cylinderSource.SetResolution(this.resolution);
                this.glyph.SetSource(cylinderSource.GetOutput());
                break;
            }
            case SPHERE: {
                vtkSphereSource sphereSource = new vtkSphereSource();
                sphereSource.SetThetaResolution(this.resolution);
                sphereSource.SetPhiResolution(this.resolution);
                this.glyph.SetSource(sphereSource.GetOutput());
                break;
            }
            case VERTEX2D: {
                vtkGlyphSource2D glyph2ddiamondsource = new vtkGlyphSource2D();
                glyph2ddiamondsource.SetGlyphTypeToCircle();
                glyph2ddiamondsource.FilledOn();
                this.glyph.SetSource(glyph2ddiamondsource.GetOutput());
                break;
            }
            case LINE2D: {
                vtkLineSource lineSource = new vtkLineSource();
                lineSource.Update();
                this.glyph.SetSource(lineSource.GetOutput());
            }
        }
        this.glyph.SetScaleFactor(this.scalFactor);
        this.scaleMode = aScaleMode;
        switch (aScaleMode) {
            case SCALE_OFF: {
                this.glyph.SetScaleModeToDataScalingOff();
                break;
            }
            case SCALE_SCALAR: {
                this.glyph.SetScaleModeToScaleByScalar();
                break;
            }
            default: {
                this.glyph.SetScaleModeToScaleByVector();
                break;
            }
            case SCALE_VECTORCOMPONENT: {
                this.glyph.SetScaleModeToScaleByVectorComponents();
            }
        }
        this.colorMode = aColorMode;
        switch (aColorMode) {
            case COLOR_SCALAR: {
                this.glyph.SetColorModeToColorByScalar();
                break;
            }
            case COLOR_SCALE: {
                this.glyph.SetColorModeToColorByScale();
                break;
            }
            default: {
                this.glyph.SetColorModeToColorByVector();
            }
        }
        if (orientByNormal) {
            this.glyph.SetVectorModeToUseNormal();
        } else {
            this.glyph.SetVectorModeToUseVector();
        }
        if (!(vtkDataSet2.GetPointData().GetScalars() == null && vtkDataSet2.GetCellData().GetScalars() == null || this.lastDataSet != null && this.lastDataSet.equals(vtkDataSet2) || !this.glyphMapper.GetLookupTable().equals(this.lookupTable))) {
            this.glyphMapper.SetScalarRange(vtkDataSet2.GetScalarRange());
            this.lookupTable.SetTableRange(vtkDataSet2.GetScalarRange());
            this.lastDataSet = vtkDataSet2;
        }
        if (this.pipelineManager.getActorList().getData().contains(this.outputCassActor)) {
            this.pipelineManager.setActorVisible(this.outputCassActor, true);
        }
        this.pipelineManager.hideInputActor(this.outputCassActor, vtkDataSet2);
        this.filterImpl.getInputDataSet().clear();
        this.filterImpl.getInputDataSet().add(vtkDataSet2);
        this.filterImpl.getOutputDataSet().clear();
        this.filterImpl.getOutputDataSet().add(this.glyph.GetOutput());
        this.pipelineManager.notifyConnectivityChange(this.cassFilter);
    }

    public String getName() {
        return this.name;
    }

    public JPopupMenu getContextualMenu() {
        return this.contextualMenu;
    }

    public void remove() {
        this.pluginManager.removePlugin((CassandraPlugin)this);
        this.pipelineManager.removeVtkObject(this.outputCassActor);
        this.pipelineManager.removeVtkObject(this.outputCassMapper);
        this.pipelineManager.removeVtkObject(this.outputCassDataset);
        this.pipelineManager.removeVtkObject(this.cassFilter);
    }

    public String toString() {
        return this.getName();
    }

    public Filter getInternalFilter() {
        return this.filterImpl;
    }

    public PlugInControlUI getControlUI() {
        return this.controlUI;
    }

    public CassandraPlugInProperty getPlugInProperty() {
        this.outputCassLookupTable = this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)this.glyphMapper.GetLookupTable());
        this.lookupTable = (vtkLookupTable)this.outputCassLookupTable.getVtkObject();
        this.outputCassScalarBar = this.pipelineManager.getVtkObject((Integer)this.outputCassLookupTable.getOutputConnectivityList().get(0));
        this.scalarBar = (vtkScalarBarActor)this.outputCassScalarBar.getVtkObject();
        SimplePlugInProperty prop = new SimplePlugInProperty();
        prop.put((Object)PERSISTENCE_KEY_SOURCE_TYPE, (Object)this.sourceType);
        prop.put((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.glyph.GetInput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_DATASET, (Object)this.glyph.GetOutput());
        prop.put((Object)PERSISTENCE_KEY_OUPUT_MAPPER, (Object)this.glyphMapper);
        prop.put((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, this.outputCassLookupTable.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, this.outputCassActor.getVtkObject());
        prop.put((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, this.outputCassScalarBar.getVtkObject());
        Point cellPosition = ((VtkObjectCellAdapter)this.cassFilter.getMetaData().get("CELL")).getPosition();
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_X, (Object)cellPosition.x);
        prop.put((Object)PERSISTENCE_KEY_CELL_POS_Y, (Object)cellPosition.y);
        return prop;
    }

    public void initAndUpdate(CassandraPlugInProperty prop) {
        this.glyph = new vtkGlyph3D();
        this.glyph.SetOutput((vtkDataObject)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_DATASET, null));
        vtkDataSet tmpInputDataSet = (vtkDataSet)prop.getSafely((Object)PERSISTENCE_KEY_INPUT_DATASET, (Object)this.glyph.GetInput());
        this.lookupTable = (vtkLookupTable)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_LOOKUP_TABLE, null);
        this.glyphMapper = (vtkPolyDataMapper)prop.getSafely((Object)PERSISTENCE_KEY_OUPUT_MAPPER, null);
        this.glyphActor = (vtkActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_ACTOR, null);
        this.scalarBar = (vtkScalarBarActor)prop.getSafely((Object)PERSISTENCE_KEY_OUTPUT_SCALAR_BAR, null);
        this.initPipeline();
        this.controlUI.setSelectedInput(this.pipelineManager.getCassandraVtkObjectByTrueVtkObject((vtkObject)tmpInputDataSet));
        this.updateGlyph(tmpInputDataSet, this.sourceType, this.scaleMode, this.colorMode, false);
    }

    public static enum glyph_color_mode {
        COLOR_VECTOR("By vector"),
        COLOR_SCALAR("By scalar value"),
        COLOR_SCALE("By size");

        private final String display;

        private glyph_color_mode(String s) {
            this.display = s;
        }

        public String toString() {
            return this.display;
        }
    }

    public static enum glyph_scale_mode {
        SCALE_VECTOR("By vector magnitude"),
        SCALE_SCALAR("By scalar value"),
        SCALE_VECTORCOMPONENT("By vector components"),
        SCALE_OFF("Do not scale by datas");

        private final String display;

        private glyph_scale_mode(String s) {
            this.display = s;
        }

        public String toString() {
            return this.display;
        }
    }

    public static enum glyph_source {
        ARROW3D("3D Arrow", 6),
        SPHERE("Sphere", 8),
        CONE("Cone", 6),
        CYLINDER("Cylinder", 6),
        BOX("Box", 0),
        ARROW2D("2D Arrow", 0),
        VERTEX2D("2D Vertex", 0),
        LINE2D("2D Line", 0);

        private final String display;
        private final int baseResolution;

        private glyph_source(String s, int resolution) {
            this.display = s;
            this.baseResolution = resolution;
        }

        public String toString() {
            return this.display;
        }

        public boolean hasResolution() {
            return this.baseResolution > 0;
        }

        public int getBaseResolution() {
            return this.baseResolution;
        }
    }
}

