/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.factory.objects;

import java.util.HashMap;
import java.util.Iterator;
import org.jfree.util.ClassComparator;
import org.jfree.util.Configuration;
import org.jfree.xml.factory.objects.ClassFactory;
import org.jfree.xml.factory.objects.ObjectDescription;

public abstract class ClassFactoryImpl
implements ClassFactory {
    private HashMap classes = new HashMap();
    private ClassComparator comparator = new ClassComparator();
    private Configuration config;

    public ClassComparator getComparator() {
        return this.comparator;
    }

    public ObjectDescription getDescriptionForClass(Class c) {
        ObjectDescription od = (ObjectDescription)this.classes.get(c);
        if (od == null) {
            return null;
        }
        return od.getInstance();
    }

    public ObjectDescription getSuperClassObjectDescription(Class d, ObjectDescription knownSuperClass) {
        if (d == null) {
            throw new NullPointerException("Description class must not be null.");
        }
        for (Class keyClass : this.classes.keySet()) {
            if (!keyClass.isAssignableFrom(d)) continue;
            ObjectDescription od = (ObjectDescription)this.classes.get(keyClass);
            if (knownSuperClass == null) {
                knownSuperClass = od;
                continue;
            }
            if (!this.comparator.isComparable(knownSuperClass.getObjectClass(), od.getObjectClass()) || this.comparator.compare(knownSuperClass.getObjectClass(), od.getObjectClass()) >= 0) continue;
            knownSuperClass = od;
        }
        if (knownSuperClass == null) {
            return null;
        }
        return knownSuperClass.getInstance();
    }

    protected void registerClass(Class key, ObjectDescription od) {
        this.classes.put(key, od);
        if (this.config != null) {
            od.configure(this.config);
        }
    }

    public Iterator getRegisteredClasses() {
        return this.classes.keySet().iterator();
    }

    public void configure(Configuration config) {
        if (config == null) {
            throw new NullPointerException("The given configuration is null");
        }
        if (this.config != null) {
            return;
        }
        this.config = config;
        for (ObjectDescription od : this.classes.values()) {
            od.configure(config);
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassFactoryImpl)) {
            return false;
        }
        ClassFactoryImpl classFactory = (ClassFactoryImpl)o;
        return this.classes.equals(classFactory.classes);
    }

    public int hashCode() {
        return this.classes.hashCode();
    }
}

