/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.jyconsole.ui;

import com.artenum.jyconsole.JyConsole;
import com.artenum.tk.ui.ToolBox;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PreferenceDialog
extends JDialog
implements ActionListener {
    public static final String OK = "ok";
    public static final String CANCEL = "cancel";
    public static final String BROWSE = "browse";
    public static final String COLOR_DEFAULT = "color.default";
    public static final String COLOR_ERROR = "color.error";
    public static final String COLOR_BG = "color.bg";
    private JyConsole console;
    private JTextField scriptDir;
    private JButton browse;
    private JButton bgColor;
    private JButton defaultTxtColor;
    private JCheckBox defaultItalic;
    private JCheckBox defaultBold;
    private JButton errorTxtColor;
    private JCheckBox errorItalic;
    private JCheckBox errorBold;
    private JButton ok;
    private JButton cancel;

    public PreferenceDialog(JyConsole jyConsole) {
        super(ToolBox.getParentFrame((Component)jyConsole));
        this.console = jyConsole;
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 3));
        JPanel jPanel = new JPanel(new GridLayout(3, 4));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Style"));
        this.bgColor = new JButton();
        this.bgColor.setBackground(Color.WHITE);
        this.bgColor.setActionCommand(COLOR_BG);
        this.bgColor.addActionListener(this);
        this.defaultBold = new JCheckBox("Bold");
        this.defaultItalic = new JCheckBox("Italic");
        this.defaultTxtColor = new JButton();
        this.defaultTxtColor.setBackground(Color.BLACK);
        this.defaultTxtColor.setActionCommand(COLOR_DEFAULT);
        this.defaultTxtColor.addActionListener(this);
        this.errorBold = new JCheckBox("Bold");
        this.errorItalic = new JCheckBox("Italic");
        this.errorTxtColor = new JButton();
        this.errorTxtColor.setBackground(Color.RED);
        this.errorTxtColor.setActionCommand(COLOR_ERROR);
        this.errorTxtColor.addActionListener(this);
        jPanel.add(new JLabel("Default"));
        jPanel.add(this.defaultTxtColor);
        jPanel.add(this.defaultBold);
        jPanel.add(this.defaultItalic);
        jPanel.add(new JLabel("Error"));
        jPanel.add(this.errorTxtColor);
        jPanel.add(this.errorBold);
        jPanel.add(this.errorItalic);
        jPanel.add(new JLabel("Bg color"));
        jPanel.add(this.bgColor);
        this.getContentPane().add(jPanel);
        jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK, 1), "Script base directory"));
        this.scriptDir = new JTextField();
        if (jyConsole.getPreferences().get("jyconsole.pref.script.dir") != null) {
            this.scriptDir.setText((String)jyConsole.getPreferences().get("jyconsole.pref.script.dir"));
        }
        this.browse = new JButton("Browse");
        this.browse.setActionCommand(BROWSE);
        this.browse.addActionListener(this);
        jPanel.add((Component)this.scriptDir, "Center");
        jPanel.add((Component)this.browse, "East");
        jPanel.setMaximumSize(new Dimension(10000, this.scriptDir.getHeight()));
        this.getContentPane().add(jPanel);
        jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 2));
        this.ok = new JButton("Ok");
        this.ok.setActionCommand(OK);
        this.ok.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand(CANCEL);
        this.cancel.addActionListener(this);
        jPanel.add(Box.createHorizontalGlue());
        jPanel.add(this.ok);
        jPanel.add(this.cancel);
        this.getContentPane().add(jPanel);
        this.pack();
        this.setLocationRelativeTo(jyConsole);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(OK)) {
            this.console.getPreferences().put("jyconsole.pref.bg.color", this.bgColor.getBackground());
            this.console.getPreferences().put("jyconsole.pref.txt.color.error", this.errorTxtColor.getBackground());
            this.console.getPreferences().put("jyconsole.pref.txt.color.normal", this.defaultTxtColor.getBackground());
            this.console.getPreferences().put("jyconsole.pref.script.dir", this.scriptDir.getText());
            this.console.savePreferences();
            this.console.setColor(this.defaultTxtColor.getBackground(), this.bgColor.getBackground());
            this.console.setBoldToStyle("default", this.defaultBold.isSelected());
            this.console.setItalicToStyle("default", this.defaultItalic.isSelected());
            this.console.setColorToStyle("error", this.errorTxtColor.getBackground());
            this.console.setBoldToStyle("error", this.errorBold.isSelected());
            this.console.setItalicToStyle("error", this.errorItalic.isSelected());
            File file = new File(this.scriptDir.getText());
            if (file.exists()) {
                this.console.getPreferences().put("jyconsole.pref.script.dir", file.getAbsolutePath());
            }
        } else if (string.equals(CANCEL)) {
            this.dispose();
        } else if (string.equals(BROWSE)) {
            JFileChooser jFileChooser = new JFileChooser((String)this.console.getPreferences().get("jyconsole.pref.script.dir"));
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setMultiSelectionEnabled(false);
            if (jFileChooser.showOpenDialog(this.console) == 0) {
                File file = jFileChooser.getSelectedFile();
                this.scriptDir.setText(file.getAbsolutePath());
            }
        } else if (string.equals(COLOR_BG)) {
            String string2 = "Choose background color";
            Color color = this.bgColor.getBackground();
            Color color2 = JColorChooser.showDialog(this, string2, color);
            if (color2 != null) {
                this.bgColor.setBackground(color2);
            }
        } else if (string.equals(COLOR_DEFAULT) || string.equals(COLOR_ERROR)) {
            Color color = null;
            String string3 = "Choose text color for style: ";
            if (string.equals(COLOR_DEFAULT)) {
                color = this.defaultTxtColor.getBackground();
                string3 = string3 + "Default";
            } else {
                color = this.errorTxtColor.getBackground();
                string3 = string3 + "Error";
            }
            Color color3 = JColorChooser.showDialog(this, string3, color);
            if (color3 == null) {
                return;
            }
            if (string.equals(COLOR_DEFAULT)) {
                this.defaultTxtColor.setBackground(color3);
            } else {
                this.errorTxtColor.setBackground(color3);
            }
        }
    }
}

