/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.iterator;

import com.artenum.penelope.mesh.interfaces.Face;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.iterator.BasicFaceIdsIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SingleFaceIterator
implements Iterator<Face> {
    private final BasicFaceIdsIterator basicFaceIds;
    private final Mesh mesh;
    private final Map<Integer, Face> faceMap;
    private final Iterator<Face> faceIterator;
    private Face currentFace;
    private final Set<Integer> alreadyUsedFaceIds;

    public SingleFaceIterator(Mesh aMesh, BasicFaceIdsIterator aBasicFaceIds, Map<Integer, Face> aFaceMap) {
        this.basicFaceIds = aBasicFaceIds;
        this.mesh = aMesh;
        this.faceMap = aFaceMap;
        this.faceIterator = this.faceMap.values().iterator();
        this.currentFace = null;
        this.alreadyUsedFaceIds = new TreeSet<Integer>();
    }

    @Override
    public boolean hasNext() {
        boolean continueLoop = true;
        while (continueLoop) {
            continueLoop = false;
            if (this.basicFaceIds.hasNext()) {
                Integer faceId = this.basicFaceIds.next();
                this.currentFace = this.mesh.getFaceById(faceId);
            } else {
                this.currentFace = this.faceIterator.hasNext() ? this.faceIterator.next() : null;
            }
            if (this.currentFace == null || !this.alreadyUsedFaceIds.contains(this.currentFace.getId())) continue;
            continueLoop = true;
        }
        if (this.currentFace != null) {
            this.alreadyUsedFaceIds.add(this.currentFace.getId());
        }
        return this.currentFace != null;
    }

    @Override
    public Face next() {
        return this.currentFace;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

