/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.color;

import com.artenum.tk.color.ColorGradientSliderPanel;
import com.artenum.tk.color.ColorGradientSliderUI;
import com.artenum.tk.color.ColorGradientThumb;
import com.artenum.tk.color.ThumbPositionEnum;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.JSlider;
import javax.swing.event.MouseInputAdapter;

public class SliderMouseInputAdapter
extends MouseInputAdapter {
    private JSlider slider;
    private ColorGradientSliderPanel colorGradientPanel;
    private int positionX;
    private int positionY;
    private ColorGradientSliderUI ui;
    private Collection<Integer> occupiedPositions;
    private int offset;

    public SliderMouseInputAdapter(ColorGradientSliderPanel panel) {
        this.colorGradientPanel = panel;
        this.occupiedPositions = new LinkedList<Integer>();
        this.slider = this.colorGradientPanel.getSlider();
        this.ui = this.colorGradientPanel.getSliderUI();
    }

    @Override
    public final void mousePressed(MouseEvent e) {
        if (!this.slider.isEnabled() || !this.colorGradientPanel.isEnabled()) {
            return;
        }
        this.positionX = e.getX();
        this.positionY = e.getY();
        this.slider.requestFocus();
        this.colorGradientPanel.setSelectedThumb(null);
        this.occupiedPositions = new LinkedList<Integer>(this.colorGradientPanel.getOccupiedPositions());
        for (ColorGradientThumb thumb : this.colorGradientPanel.getThumbs()) {
            if (!thumb.getBounds().contains(this.positionX, this.positionY)) continue;
            this.colorGradientPanel.setSelectedThumb(thumb);
            this.occupiedPositions.remove(thumb.getColorIndex());
            this.slider.setValueIsAdjusting(true);
            switch (this.slider.getOrientation()) {
                case 1: {
                    this.offset = this.positionY - thumb.getLocation().y;
                    break;
                }
                case 0: {
                    this.offset = this.positionX - thumb.getLocation().x;
                    break;
                }
            }
            return;
        }
    }

    @Override
    public final void mouseDragged(MouseEvent e) {
        if (!this.slider.isEnabled() || !this.slider.getValueIsAdjusting() || this.colorGradientPanel.getSelectedThumb() == null) {
            return;
        }
        if (this.colorGradientPanel.getSelectedThumb().getPositionEnum() != ThumbPositionEnum.OTHER) {
            return;
        }
        int thumbMiddle = 0;
        int index = 0;
        this.positionX = e.getX();
        this.positionY = e.getY();
        Rectangle bounds = this.colorGradientPanel.getSelectedThumb().getBounds();
        Rectangle trackRect = ((ColorGradientSliderUI)this.slider.getUI()).getTrackRectangle();
        switch (this.slider.getOrientation()) {
            case 1: {
                int halfThumbHeight = bounds.height / 2;
                int thumbTop = e.getY() - this.offset;
                int trackTop = trackRect.y;
                int trackBottom = trackRect.y + (trackRect.height - 1);
                thumbTop = Math.max(thumbTop, trackTop - halfThumbHeight);
                thumbTop = Math.min(thumbTop, trackBottom - halfThumbHeight);
                thumbMiddle = thumbTop + halfThumbHeight;
                index = this.ui.valueForYPosition(thumbMiddle);
                if (this.occupiedPositions.contains(index)) {
                    int colorHeight = this.slider.getHeight() / this.colorGradientPanel.getNbColors();
                    index = thumbTop - index * colorHeight < colorHeight / 2 ? --index : ++index;
                }
                this.colorGradientPanel.getSelectedThumb().setColorIndex(index);
                this.ui.setThumbLocation(this.colorGradientPanel.getSelectedThumb(), bounds.x, thumbTop);
                break;
            }
            case 0: {
                int halfThumbWidth = bounds.width / 2;
                int thumbLeft = e.getX() - this.offset;
                int trackLeft = trackRect.x;
                int trackRight = trackRect.x + (trackRect.width - 1);
                thumbLeft = Math.max(thumbLeft, trackLeft - halfThumbWidth);
                thumbLeft = Math.min(thumbLeft, trackRight - halfThumbWidth);
                thumbMiddle = thumbLeft + halfThumbWidth;
                index = this.ui.valueForXPosition(thumbMiddle);
                if (this.occupiedPositions.contains(index)) {
                    int colorWidth = this.slider.getWidth() / this.colorGradientPanel.getNbColors();
                    index = thumbLeft - index * colorWidth < colorWidth / 2 ? --index : ++index;
                }
                this.colorGradientPanel.getSelectedThumb().setColorIndex(index);
                this.ui.setThumbLocation(this.colorGradientPanel.getSelectedThumb(), thumbLeft, bounds.y);
                break;
            }
        }
    }

    @Override
    public final void mouseReleased(MouseEvent e) {
        if (!this.slider.isEnabled()) {
            return;
        }
        this.offset = 0;
        this.slider.setValueIsAdjusting(false);
        this.slider.repaint();
        this.colorGradientPanel.modificationEnded();
    }
}

