/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.tk.ui.util;

import com.artenum.tk.panel.JFormattedLinePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class RadioButtonsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 2680676501381834292L;
    private final JButton cancelButton;
    private final JButton okButton;
    private boolean answer = false;
    private final int verticalDefaultComponentSize = 30;
    private static final String OK_ACTION_CMD = "ok.action.command";
    private static final String CANCEL_ACTION_CMD = "escape.action.command";
    private final JRadioButton[] radioButtons;
    private final ButtonGroup group;

    public RadioButtonsDialog(String title, Component topComponent, String[] radioButtonLabels) {
        int i;
        this.setModal(true);
        this.setTitle(title);
        this.setLayout(new BorderLayout(5, 5));
        JPanel mainPanel = new JPanel();
        GridBagLayout mainLayout = new GridBagLayout();
        Insets insets2 = new Insets(2, 2, 2, 2);
        mainPanel.setLayout(mainLayout);
        mainPanel.add(topComponent, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, insets2, 0, 0));
        mainPanel.add((Component)new JLabel(" "), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, insets2, 0, 0));
        int numButtons = radioButtonLabels.length;
        this.radioButtons = new JRadioButton[numButtons];
        this.group = new ButtonGroup();
        for (int radioButtonNameIndex = 0; radioButtonNameIndex < numButtons; ++radioButtonNameIndex) {
            String radioButtonLabel = radioButtonLabels[radioButtonNameIndex];
            this.radioButtons[radioButtonNameIndex] = new JRadioButton(radioButtonLabel);
            this.radioButtons[radioButtonNameIndex].setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 10));
        }
        for (i = 0; i < numButtons; ++i) {
            this.group.add(this.radioButtons[i]);
        }
        this.radioButtons[0].setSelected(true);
        for (i = 0; i < numButtons; ++i) {
            mainPanel.add((Component)this.radioButtons[i], new GridBagConstraints(0, 2 + i, 1, 1, 0.0, 0.0, 10, 1, insets2, 0, 0));
        }
        this.add((Component)mainPanel, "Center");
        JFormattedLinePanel actionPanel = new JFormattedLinePanel(this.verticalDefaultComponentSize);
        actionPanel.add(Box.createHorizontalGlue());
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setActionCommand(CANCEL_ACTION_CMD);
        this.cancelButton.addActionListener(this);
        actionPanel.add(this.cancelButton);
        actionPanel.add(Box.createHorizontalBox(), 2);
        this.okButton = new JButton("OK");
        this.okButton.setActionCommand(OK_ACTION_CMD);
        this.okButton.addActionListener(this);
        actionPanel.add(this.okButton);
        this.add((Component)actionPanel, "South");
    }

    public boolean showDialog() {
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        return this.answer;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        String cmd = evt.getActionCommand();
        this.answer = cmd.equals(OK_ACTION_CMD);
        this.setVisible(false);
    }

    public int getSelectedChoice() {
        for (int i = 0; i < this.radioButtons.length; ++i) {
            if (!this.radioButtons[i].isSelected()) continue;
            return i;
        }
        return -1;
    }
}

