/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.util;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.VtkObjectListModel;
import javax.swing.ComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class VtkObjectComboBoxModel
implements ComboBoxModel,
ListDataListener {
    private CassandraObject filteredItem;
    private CassandraObject selectedItem;
    private VtkObjectListModel listModel;
    private int filteredIndex = -1;

    public VtkObjectComboBoxModel(VtkObjectListModel listModel, CassandraObject filteredItem) {
        this.filteredItem = filteredItem;
        this.listModel = listModel;
        this.filteredIndex = listModel.getVtkObjectIndex(filteredItem);
        this.listModel.addListDataListener(this);
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedItem;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedItem = (CassandraObject)anItem;
    }

    public void setSelectedEncapsulateItem(Object anItem) {
        this.selectedItem = this.listModel.getVtkObject(anItem);
    }

    @Override
    public int getSize() {
        return this.listModel.getSize() - (this.filteredIndex != -1 ? 1 : 0);
    }

    @Override
    public Object getElementAt(int index) {
        if (this.filteredIndex != -1 && this.filteredIndex < index) {
            --index;
        }
        return this.listModel.getElementAt(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listModel.addListDataListener(l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listModel.removeListDataListener(l);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.filteredIndex = this.listModel.getVtkObjectIndex(this.filteredItem);
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.filteredIndex = this.listModel.getVtkObjectIndex(this.filteredItem);
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        this.filteredIndex = this.listModel.getVtkObjectIndex(this.filteredItem);
    }
}

