/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.mesh.element;

import com.artenum.penelope.mesh.MeshType;
import com.artenum.penelope.mesh.interfaces.Edge;
import com.artenum.penelope.mesh.interfaces.Identifiable;
import com.artenum.penelope.mesh.interfaces.Mesh;
import com.artenum.penelope.mesh.interfaces.Simplex;
import com.artenum.penelope.mesh.interfaces.Vertex;

public abstract class AbstractEdge
implements Edge {
    private int id;
    private final Mesh mesh;
    private final Vertex[] vertexArray;

    public AbstractEdge(int uniqueId, Mesh aMesh, Vertex ... aVertexArray) {
        this.id = uniqueId;
        this.mesh = aMesh;
        this.vertexArray = aVertexArray;
    }

    public AbstractEdge(Mesh aMesh, Vertex ... aVertexArray) {
        this(0, aMesh, aVertexArray);
    }

    @Override
    public Mesh getMesh() {
        return this.mesh;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int anId) {
        this.id = anId;
    }

    @Override
    public int compareTo(Identifiable simplexToCompareWith) {
        return this.id - simplexToCompareWith.getId();
    }

    @Override
    public Vertex[] getVertices() {
        return this.vertexArray;
    }

    @Override
    public int getNbVertices() {
        return this.vertexArray.length;
    }

    @Override
    public Vertex getVertexAt(int position) {
        return this.vertexArray[position];
    }

    @Override
    public int getVertexPosition(int vertexId) {
        int position = -1;
        for (int i = 0; position == -1 && i < this.vertexArray.length; ++i) {
            if (this.vertexArray[i].getId() != vertexId) continue;
            position = i;
        }
        return position;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof Simplex) {
            result = ((Simplex)obj).getId() == this.getId();
        }
        return result;
    }

    public int hashCode() {
        return this.id;
    }

    @Override
    public int getSimplexDimension() {
        return 1;
    }

    @Override
    public MeshType getMeshType() {
        return MeshType.EDGE;
    }

    @Override
    public double[] getIsoBarycentre() {
        int spaceDimension = this.getVertexAt(0).getPoint().getSpaceDimension();
        double[] barycentre = new double[spaceDimension];
        for (Vertex vertex : this.getVertices()) {
            for (int i = 0; i < spaceDimension; ++i) {
                int n = i;
                barycentre[n] = barycentre[n] + vertex.getPoint().getCoord()[i];
            }
        }
        for (int i = 0; i < spaceDimension; ++i) {
            barycentre[i] = barycentre[i] / (double)this.getNbVertices();
        }
        return barycentre;
    }
}

