/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.penelope.plugin.vtk;

import com.artenum.penelope.plugin.vtk.VtkContextLoader;
import java.io.FileWriter;
import java.io.IOException;
import vtk.vtkDataArray;
import vtk.vtkDataObject;
import vtk.vtkDataSet;
import vtk.vtkDataSetReader;
import vtk.vtkDataSetWriter;
import vtk.vtkFloatArray;
import vtk.vtkProbeFilter;
import vtk.vtkUnstructuredGrid;

public class VtkDataSetComparator {
    private double errorMax = 0.0;
    private double errorMin = 0.0;
    private final double[] errorDistribution = new double[this.samplingLevel];
    private int samplingLevel = 64;
    private double diff;
    private double dx;
    private int tmpIndex;
    private vtkDataSet evaluatedDataSet;
    private vtkDataSet refDataSet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String evaluatedDSFileName = null;
        String differentialDSFileName = null;
        String errorDistributionFileName = null;
        System.out.println(args.length);
        try {
            System.out.println(args[0]);
            System.out.println(args[1]);
            evaluatedDSFileName = args[1];
            System.out.println(args[2]);
            differentialDSFileName = args[2];
            errorDistributionFileName = differentialDSFileName + "errorDistribution.txt";
        }
        catch (Exception e) {
            VtkDataSetComparator.printUsage();
            System.exit(1);
        }
        System.out.println("# Start");
        VtkContextLoader.load();
        System.out.println("# VTK context loaded");
        vtkDataSetReader dataSetReader = new vtkDataSetReader();
        dataSetReader.SetFileName(evaluatedDSFileName);
        dataSetReader.Update();
        vtkDataSet data1 = dataSetReader.GetOutput();
        dataSetReader.SetFileName(evaluatedDSFileName);
        dataSetReader.Update();
        vtkDataSet data2 = dataSetReader.GetOutput();
        System.out.println("# Vtk files read");
        VtkDataSetComparator comparator = new VtkDataSetComparator();
        vtkDataSet outDS = comparator.computeDataSetDifferential(data1, data2);
        vtkDataSetWriter writer = new vtkDataSetWriter();
        writer.SetFileTypeToBinary();
        writer.SetFileName(differentialDSFileName);
        writer.SetInput((vtkDataObject)outDS);
        writer.Write();
        FileWriter errorDistribFile = null;
        try {
            errorDistribFile = new FileWriter(errorDistributionFileName);
            double[] distrib = comparator.getErrorDistribution();
            errorDistribFile.write("# " + comparator.getErrorMin() + " " + comparator.getErrorMax() + "\n");
            for (int i = 0; i < comparator.getSamplingLevel(); ++i) {
                errorDistribFile.write(i + " " + distrib[i] + "\n");
            }
            errorDistribFile.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        finally {
            try {
                if (errorDistribFile != null) {
                    errorDistribFile.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("End");
    }

    private static void printUsage() {
        System.out.println("Usage: ");
    }

    public vtkDataSet probeDataSetBy(vtkDataSet evaluatedDataSet, vtkDataSet refDataSet) {
        this.evaluatedDataSet = evaluatedDataSet;
        this.refDataSet = refDataSet;
        vtkProbeFilter probe = new vtkProbeFilter();
        probe.SetInput(this.refDataSet);
        probe.SetSource((vtkDataObject)this.evaluatedDataSet);
        probe.Update();
        probe.GetOutput().UpdateData();
        return probe.GetOutput();
    }

    public vtkDataSet computeDataSetDifferential(vtkDataSet evaluatedData, vtkDataSet refDataSet) {
        int i;
        vtkDataSet probedDataSet = this.probeDataSetBy(refDataSet, evaluatedData);
        vtkDataSetWriter writer = new vtkDataSetWriter();
        writer.SetFileTypeToBinary();
        writer.SetFileName("/Users/juju/DataSetToCompare/probedData.vtk");
        writer.SetInput((vtkDataObject)probedDataSet);
        writer.Write();
        vtkDataArray refArray = probedDataSet.GetPointData().GetScalars();
        int nbdata = refArray.GetNumberOfTuples();
        vtkDataArray sourceDataArray = evaluatedData.GetPointData().GetScalars();
        vtkUnstructuredGrid differentialDataSet = new vtkUnstructuredGrid();
        differentialDataSet.DeepCopy((vtkDataObject)probedDataSet);
        vtkFloatArray diffArray = new vtkFloatArray();
        diffArray.SetName("differential");
        diffArray.SetNumberOfTuples(nbdata);
        diffArray.SetNumberOfValues(1);
        this.errorMin = Math.abs(refArray.GetTuple1(0) - sourceDataArray.GetTuple1(0));
        this.errorMax = Math.abs(refArray.GetTuple1(0) - sourceDataArray.GetTuple1(0));
        for (i = 0; i < nbdata; ++i) {
            this.diff = Math.abs(refArray.GetTuple1(i) - sourceDataArray.GetTuple1(i));
            diffArray.InsertTuple1(i, this.diff);
            if (this.diff < Math.abs(this.errorMin)) {
                this.errorMin = Math.abs(this.diff);
            }
            if (!(this.diff > Math.abs(this.errorMax))) continue;
            this.errorMax = Math.abs(this.diff);
        }
        differentialDataSet.GetPointData().SetScalars((vtkDataArray)diffArray);
        this.dx = (this.errorMax - this.errorMin) / (double)(this.samplingLevel - 1);
        for (i = 0; i < nbdata; ++i) {
            this.tmpIndex = (int)Math.round((Math.abs(diffArray.GetTuple1(i)) - this.errorMin) / this.dx);
            this.errorDistribution[this.tmpIndex] = this.errorDistribution[this.tmpIndex] + 1.0;
        }
        return differentialDataSet;
    }

    public int getSamplingLevel() {
        return this.samplingLevel;
    }

    public void setSamplingLevel(int samplingLevel) {
        this.samplingLevel = samplingLevel;
    }

    public vtkDataSet getInputDataSet() {
        return this.evaluatedDataSet;
    }

    public void setInputDataSet(vtkDataSet inputDataSet) {
        this.evaluatedDataSet = inputDataSet;
    }

    public vtkDataSet getSourceDataSet() {
        return this.refDataSet;
    }

    public void setSourceDataSet(vtkDataSet sourceDataSet) {
        this.refDataSet = sourceDataSet;
    }

    public double getErrorMax() {
        return this.errorMax;
    }

    public double getErrorMin() {
        return this.errorMin;
    }

    public double[] getErrorDistribution() {
        return this.errorDistribution;
    }
}

