/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.action;

import com.artenum.cassandra.PreferenceListener;
import com.artenum.cassandra.action.ExitAction;
import com.artenum.cassandra.action.ThreadedFileLoader;
import com.artenum.cassandra.launcher.DynamicClassLoader;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.io.PipelineToJythonExporter;
import com.artenum.cassandra.plugin.CassandraPluginIntegrator;
import com.artenum.cassandra.plugin.DynamicPluginMenu;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.cassandra.ui.CassandraGUI;
import com.artenum.cassandra.ui.CassandraHelp;
import com.artenum.cassandra.ui.dialog.ExportPipelineDialog;
import com.artenum.cassandra.ui.dialog.ThreadedProgressBarDialog;
import com.artenum.cassandra.ui.popup.SaveDataSetToVtkFilePopupMenu;
import com.artenum.cassandra.util.CassandraToolBox;
import com.artenum.cassandra.util.FileItem;
import com.artenum.cassandra.util.RecentFilesManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class CassandraActionListener
implements ActionListener,
PreferenceListener {
    public static final String LOAD_PLUGIN = "LOAD_PLUGIN";
    public static final String OPEN_VTK_FILE = "OPEN_VTK_FILE";
    public static final String OPEN_RECENT_VTK_FILE = "OPEN_RECENT_VTK_FILE";
    public static final String SAVE_VTK_FILE = "SAVE_VTK_FILE";
    public static final String IMPORT_DATA_FILE = "IMPORT_DATA_FILE";
    public static final String EXPORT_DATA_FILE = "EXPORT_DATA_FILE";
    public static final String SAVE_VTK_VIEW = "SAVE_VTK_VIEW";
    public static final String EXIT = "EXIT";
    public static final String ABOUT_CASSANDRA = "ABOUT_CASSANDRA";
    public static final String VIEW_RENDERER = "RENDERER";
    public static final String VIEW_CONSOLE = "CONSOLE";
    public static final String VIEW_PIPELINE = "PIPELINE";
    public static final String SET_BG_COLOR = "SET_BG_COLOR";
    public static final String SET_AMBIANT_LIGHT = "SET_AMBIANT_LIGHT";
    public static final String VIEW_AXIS = "AXIS";
    public static final String SET_TITLE = "SET_TITLE";
    public static final String IMPORT_PIPELINE_FROM_JYTHON = "import.pipeline.from.jython";
    public static final String EXPORT_PIPELINE_TO_JYTHON = "export.pipeline.to.jython";
    public static final String SET_VIEW_XY = "SET_VIEW_XY";
    public static final String SET_VIEW_YX = "SET_VIEW_YX";
    public static final String SET_VIEW_XZ = "SET_VIEW_XZ";
    public static final String SET_VIEW_ZX = "SET_VIEW_ZX";
    public static final String SET_VIEW_YZ = "SET_VIEW_YZ";
    public static final String SET_VIEW_ZY = "SET_VIEW_ZY";
    public static final String RESET_VIEW = "RESET_VIEW";
    public static final String PARALLEL_PROJECTION = "PARALLEL_PROJECTION";
    public static final String PREF_PLUGIN_OPEN_DIR = "cassandra.pref.plugin.dir";
    public static final String PREF_VTK_FILE_OPEN_DIR = "cassandra.pref.vtk.file.dir";
    public static final String PREF_IMAGE_SAVE_DIR = "cassandra.pref.image.save.dir";
    public static final String PREF_AUTO_UPDATE_VTK_FILE_OPEN_DIR = "cassandra.pref.auto.update";
    private final PipeLineManager pipeLineManager;
    private final CassandraGUI view;
    private final PluginManager pluginManager;
    private Component parentComponent;
    private DynamicPluginMenu dynamicPluginMenu;
    private final ArrayList<String> pluginClassNameList;
    private JDialog about;
    private ExitAction exitAction;
    private Hashtable<String, Object> prefTable;
    private File pluginDir;
    private File openVtkFileDir;
    private File imageSaveDir;
    private boolean autoUpdateOpenVtkFileDir;
    private RecentFilesManager recentFileManager;

    public CassandraActionListener(CassandraGUI view, PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        this.view = view;
        this.pluginClassNameList = new ArrayList();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals(LOAD_PLUGIN)) {
            JFileChooser chooser = new JFileChooser();
            if (this.pluginDir != null) {
                chooser.setCurrentDirectory(this.pluginDir);
            }
            chooser.setMultiSelectionEnabled(true);
            chooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".jar");
                }

                @Override
                public String getDescription() {
                    return "Jar files";
                }
            });
            if (chooser.showOpenDialog(this.parentComponent) == 0) {
                File[] jarFiles = chooser.getSelectedFiles();
                for (int i = 0; i < jarFiles.length; ++i) {
                    if (!jarFiles[i].isFile()) continue;
                    DynamicClassLoader.getInstance().addJar(jarFiles[i]);
                }
                this.reloadPlugings();
            }
        } else if (actionCommand.equals(SET_VIEW_XY)) {
            this.pipeLineManager.getCassandraView().setXYView();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(SET_VIEW_YX)) {
            this.pipeLineManager.getCassandraView().setYXView();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(SET_VIEW_XZ)) {
            this.pipeLineManager.getCassandraView().setXZView();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(SET_VIEW_ZX)) {
            this.pipeLineManager.getCassandraView().setZXView();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(SET_VIEW_YZ)) {
            this.pipeLineManager.getCassandraView().setYZView();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(SET_VIEW_ZY)) {
            this.pipeLineManager.getCassandraView().setZYView();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(RESET_VIEW)) {
            this.pipeLineManager.getCassandraView().resetCamera();
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(EXIT)) {
            if (this.exitAction == null) {
                System.exit(0);
            } else {
                this.exitAction.exit();
            }
        } else if (actionCommand.equals(OPEN_VTK_FILE)) {
            this.vtkFileChooserAndLoad();
        } else if (actionCommand.equals("recent.selected.file.action")) {
            File recentFile = ((FileItem)e.getSource()).getFile();
            if (recentFile.isFile() && this.isVtkFile(recentFile)) {
                ThreadedFileLoader loader = new ThreadedFileLoader(this.pipeLineManager, recentFile);
                loader.setProgressMonitor(new ThreadedProgressBarDialog());
                loader.start();
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "File not found or not format supported. Please select another file.", "File not supported.", -1);
                this.vtkFileChooserAndLoad();
            }
        } else if (actionCommand.equals("selected.bookmark.action")) {
            File bookmarkedFile = ((FileItem)e.getSource()).getFile();
            if (bookmarkedFile.isFile() && this.isVtkFile(bookmarkedFile)) {
                ThreadedFileLoader loader = new ThreadedFileLoader(this.pipeLineManager, bookmarkedFile);
                loader.setProgressMonitor(new ThreadedProgressBarDialog());
                loader.start();
            } else {
                JOptionPane.showMessageDialog(new JFrame(), "File not found or not format supported. Please select another file.", "File not supported.", -1);
                this.vtkFileChooserAndLoad();
            }
        } else if (actionCommand.equals(VIEW_CONSOLE)) {
            if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                this.view.showConsole();
            } else {
                this.view.hideConsole();
            }
            this.pipeLineManager.deepValidateView();
        } else if (actionCommand.equals(SET_BG_COLOR)) {
            Color c = JColorChooser.showDialog(this.view, "Background color", Color.BLACK);
            if (c != null) {
                this.pipeLineManager.getCassandraView().setBackground(c);
            }
            this.pipeLineManager.validateViewAndGo();
        } else if (actionCommand.equals(SET_AMBIANT_LIGHT)) {
            Color c = JColorChooser.showDialog(this.view, "Ambiant light", Color.BLACK);
            if (c != null) {
                this.pipeLineManager.getCassandraView().setAmbiantLight(c);
            }
            this.pipeLineManager.validateViewAndGo();
        } else if (!actionCommand.equals(SET_TITLE)) {
            if (actionCommand.equals(VIEW_AXIS)) {
                this.pipeLineManager.setAxisVisible(((JCheckBoxMenuItem)e.getSource()).isSelected());
                this.pipeLineManager.validateViewAndGo();
            } else if (actionCommand.equals(PARALLEL_PROJECTION)) {
                this.pipeLineManager.setParallelProjection(((JCheckBoxMenuItem)e.getSource()).isSelected());
                this.pipeLineManager.validateViewAndGo();
            } else if (actionCommand.equals(VIEW_PIPELINE)) {
                if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                    this.view.showPipeLine();
                } else {
                    this.view.hidePipeLine();
                }
                this.pipeLineManager.deepValidateView();
            } else if (actionCommand.equals(SAVE_VTK_VIEW)) {
                JFileChooser chooser = new JFileChooser();
                if (this.imageSaveDir != null) {
                    chooser.setCurrentDirectory(this.imageSaveDir);
                }
                chooser.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File f) {
                        if (f.isDirectory()) {
                            return true;
                        }
                        return f.isFile() && (f.getName().toLowerCase().endsWith(".tif") || f.getName().toLowerCase().endsWith(".tiff"));
                    }

                    @Override
                    public String getDescription() {
                        return "Tiff image file";
                    }
                });
                chooser.showSaveDialog(this.view);
                File fileToSave = chooser.getSelectedFile();
                this.imageSaveDir = fileToSave.getParentFile();
                if (fileToSave != null) {
                    String filePath = fileToSave.getAbsolutePath();
                    if (!filePath.toLowerCase().endsWith(".tif") && !filePath.toLowerCase().endsWith(".tiff")) {
                        filePath = filePath + ".tiff";
                    }
                    this.pipeLineManager.getCassandraView().saveToTIFF(filePath);
                }
            } else if (actionCommand.equals(VIEW_RENDERER)) {
                if (((JCheckBoxMenuItem)e.getSource()).isSelected()) {
                    this.view.showRenderer();
                } else {
                    this.view.hideRenderer();
                }
                this.pipeLineManager.deepValidateView();
            } else if (actionCommand.equals(SAVE_VTK_FILE)) {
                SaveDataSetToVtkFilePopupMenu saveMenu = new SaveDataSetToVtkFilePopupMenu(this.pipeLineManager, this.pluginManager, null);
                saveMenu.setVisible(true);
            } else if (actionCommand.equals(ABOUT_CASSANDRA)) {
                if (this.about == null) {
                    this.about = new CassandraHelp(this.view);
                }
                this.about.setLocationRelativeTo(null);
                this.about.setVisible(true);
            } else if (actionCommand.equals(EXPORT_PIPELINE_TO_JYTHON)) {
                ExportPipelineDialog dialog = new ExportPipelineDialog(null, this.pipeLineManager);
                int answer = dialog.showMessageDialog();
                System.out.println("answer = " + answer);
                if (answer == 0) {
                    PipelineToJythonExporter exporter = new PipelineToJythonExporter();
                    exporter.setPipeline(this.pipeLineManager);
                    exporter.setSelectedVtkObjectList(this.pipeLineManager.getVtkObjectHashtable());
                    exporter.setOutputFile(dialog.getSelectedFile());
                    exporter.write();
                } else {
                    System.out.println("Nothing selected");
                }
            } else if (actionCommand.equals(IMPORT_PIPELINE_FROM_JYTHON)) {
                JFileChooser chooser = new JFileChooser();
                int answer = chooser.showOpenDialog(this.view);
                if (answer == 0) {
                    File selectedFile = chooser.getSelectedFile();
                    System.out.println(selectedFile.getName());
                    this.view.getPyConsole().executePythonFile(selectedFile);
                }
            } else {
                System.out.println(actionCommand);
            }
        }
    }

    public boolean isVtkFile(File file) {
        FileFilter filter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".vtk") || f.getName().endsWith(".vtu");
            }

            @Override
            public String getDescription() {
                return "Vtk files (.vtk, .vtu...)";
            }
        };
        return filter.accept(file);
    }

    public void vtkFileChooserAndLoad() {
        JFileChooser chooser = new JFileChooser();
        if (this.openVtkFileDir != null) {
            chooser.setCurrentDirectory(this.openVtkFileDir);
        }
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".vtk") || f.getName().endsWith(".vtu");
            }

            @Override
            public String getDescription() {
                return "Vtk files (.vtk, .vtu...)";
            }
        });
        if (chooser.showOpenDialog(this.view) == 0) {
            int i;
            File[] vtkFiles = chooser.getSelectedFiles();
            CassandraToolBox.sortFileList(vtkFiles);
            ThreadedFileLoader loader = new ThreadedFileLoader(this.pipeLineManager);
            loader.setProgressMonitor(new ThreadedProgressBarDialog());
            for (i = 0; i < vtkFiles.length; ++i) {
                loader.addFileToLoad(vtkFiles[i]);
            }
            loader.start();
            for (i = 0; i < vtkFiles.length; ++i) {
                if (!this.autoUpdateOpenVtkFileDir) continue;
                this.openVtkFileDir = vtkFiles[i].getParentFile();
                if (this.recentFileManager == null) continue;
                this.recentFileManager.addFile(vtkFiles[i]);
            }
        }
    }

    public void reloadPlugings() {
        for (String className : DynamicClassLoader.getInstance().getPluginIntegratorList()) {
            if (this.pluginClassNameList.contains(className)) continue;
            this.pluginClassNameList.add(className);
            try {
                ((CassandraPluginIntegrator)DynamicClassLoader.getInstance().getPluginIntegrator(className)).integratePluginsInFramework(this.pipeLineManager, this.pluginManager, this.dynamicPluginMenu);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void setDynamicPluginMenu(DynamicPluginMenu dynaPluginMenu) {
        this.dynamicPluginMenu = dynaPluginMenu;
    }

    public void setParentComponent(Component parentComponent) {
        this.parentComponent = parentComponent;
    }

    public void setExitAction(ExitAction exitAction) {
        this.exitAction = exitAction;
    }

    @Override
    public void setPreferences(Hashtable<String, Object> prefTable) {
        this.prefTable = prefTable;
    }

    @Override
    public void preferenceChanged() {
        if (this.prefTable != null) {
            try {
                this.autoUpdateOpenVtkFileDir = !this.prefTable.get(PREF_AUTO_UPDATE_VTK_FILE_OPEN_DIR).equals("false");
            }
            catch (Exception e) {
                System.out.println("Impossible to change the following property: cassandra.pref.auto.update");
                this.prefTable.put(PREF_AUTO_UPDATE_VTK_FILE_OPEN_DIR, "false");
            }
            try {
                this.imageSaveDir = (File)this.prefTable.get(PREF_IMAGE_SAVE_DIR);
            }
            catch (Exception e) {
                System.out.println("Impossible to change the following property: cassandra.pref.image.save.dir");
            }
            try {
                this.pluginDir = (File)this.prefTable.get(PREF_PLUGIN_OPEN_DIR);
            }
            catch (Exception e) {
                System.out.println("Impossible to change the following property: cassandra.pref.plugin.dir");
            }
            try {
                this.openVtkFileDir = (File)this.prefTable.get(PREF_VTK_FILE_OPEN_DIR);
            }
            catch (Exception e) {
                System.out.println("Impossible to change the following property: cassandra.pref.vtk.file.dir");
                this.openVtkFileDir = new File(".");
            }
        }
    }

    public RecentFilesManager getRecentFileManager() {
        return this.recentFileManager;
    }

    public void setRecentFileManager(RecentFilesManager recentFileManager) {
        this.recentFileManager = recentFileManager;
    }
}

