/*
 * Decompiled with CFR 0.152.
 */
package com.artenum.cassandra.pipeline.graph;

import com.artenum.cassandra.pipeline.CassandraObject;
import com.artenum.cassandra.pipeline.ConnectivityListener;
import com.artenum.cassandra.pipeline.Filter;
import com.artenum.cassandra.pipeline.PipeLineManager;
import com.artenum.cassandra.pipeline.graph.VtkObjectCellAdapter;
import com.artenum.cassandra.pipeline.graph.VtkObjectUI;
import com.artenum.cassandra.plugin.PluginManager;
import com.artenum.graph.impl.DefaultGraphModel;
import com.artenum.graph.interfaces.Cell;
import com.artenum.graph.interfaces.GraphViewListener;
import java.util.Iterator;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import vtk.vtkActor;
import vtk.vtkMapper;
import vtk.vtkScalarBarActor;

public class VtkPipeLineGraphModel
extends DefaultGraphModel
implements ListDataListener,
ConnectivityListener {
    private PipeLineManager pipeLineManager;
    private PluginManager pluginManager;
    private int lastYPos = 0;

    public VtkPipeLineGraphModel(PipeLineManager pipeLineManager, PluginManager pluginManager) {
        this.pipeLineManager = pipeLineManager;
        this.pluginManager = pluginManager;
        pipeLineManager.getActorList().addListDataListener(this);
        pipeLineManager.getMapperList().addListDataListener(this);
        pipeLineManager.getDataSetList().addListDataListener(this);
        pipeLineManager.getFilterList().addListDataListener(this);
        pipeLineManager.getLookupTableList().addListDataListener(this);
        pipeLineManager.getScalarBarList().addListDataListener(this);
        pipeLineManager.getTextActorList().addListDataListener(this);
        pipeLineManager.addConnectivityListener(this);
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    @Override
    public void reload() {
        Object[] cell = this.getCellList().toArray();
        for (int i = 0; i < cell.length; ++i) {
            ((VtkObjectCellAdapter)cell[i]).savePosition();
        }
        super.reload();
    }

    public void alignVerticalPosition(VtkObjectUI cellUI) {
        if (cellUI.getPosition().y < this.lastYPos) {
            cellUI.getPosition().y = this.lastYPos;
        } else {
            this.lastYPos = cellUI.getPosition().y;
        }
    }

    public void updateCell() {
        CassandraObject tmp2 = null;
        VtkObjectCellAdapter tmpCell = null;
        for (CassandraObject tmp2 : this.pipeLineManager.getActorList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
        for (CassandraObject tmp2 : this.pipeLineManager.getMapperList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
        for (CassandraObject tmp2 : this.pipeLineManager.getDataSetList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
                this.alignVerticalPosition((VtkObjectUI)((Object)tmpCell.getUI()));
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
        for (CassandraObject tmp2 : this.pipeLineManager.getFilterList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
                this.alignVerticalPosition((VtkObjectUI)((Object)tmpCell.getUI()));
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
        for (CassandraObject tmp2 : this.pipeLineManager.getLookupTableList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
        for (CassandraObject tmp2 : this.pipeLineManager.getScalarBarList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
        for (CassandraObject tmp2 : this.pipeLineManager.getTextActorList().getData()) {
            if (tmp2.getMetaData().get("CELL") == null) {
                tmpCell = new VtkObjectCellAdapter(tmp2);
                tmp2.getMetaData().put("CELL", tmpCell);
            } else {
                tmpCell = (VtkObjectCellAdapter)tmp2.getMetaData().get("CELL");
            }
            if (this.getCellList().contains(tmpCell)) continue;
            this.insertCell(tmpCell);
        }
    }

    public void updateConnection() {
        this.getConnections().clear();
        Object[] cellList = this.getCellList().toArray();
        for (int i = 0; i < cellList.length; ++i) {
            ((Cell)cellList[i]).getConnections().clear();
        }
        for (CassandraObject actor : this.pipeLineManager.getActorList().getData()) {
            actor.clearInputConnectivityList();
            actor.clearOutputConnecvityLsit();
        }
        for (CassandraObject dataset : this.pipeLineManager.getDataSetList().getData()) {
            dataset.clearInputConnectivityList();
            dataset.clearOutputConnecvityLsit();
        }
        for (CassandraObject mapper : this.pipeLineManager.getMapperList().getData()) {
            mapper.clearInputConnectivityList();
            mapper.clearOutputConnecvityLsit();
        }
        for (CassandraObject lookupTable : this.pipeLineManager.getLookupTableList().getData()) {
            lookupTable.clearInputConnectivityList();
            lookupTable.clearOutputConnecvityLsit();
        }
        for (CassandraObject filter : this.pipeLineManager.getFilterList().getData()) {
            filter.clearInputConnectivityList();
            filter.clearOutputConnecvityLsit();
        }
        for (CassandraObject scalarBar : this.pipeLineManager.getScalarBarList().getData()) {
            scalarBar.clearInputConnectivityList();
            scalarBar.clearOutputConnecvityLsit();
        }
        for (CassandraObject actor : this.pipeLineManager.getActorList().getData()) {
            if (!(actor.getVtkObject() instanceof vtkActor)) continue;
            vtkMapper actorMapper = ((vtkActor)actor.getVtkObject()).GetMapper();
            for (CassandraObject mapper : this.pipeLineManager.getMapperList().getData()) {
                if (!mapper.getVtkObject().equals(actorMapper)) continue;
                this.connect((Cell)actor.getMetaData().get("CELL"), (Cell)mapper.getMetaData().get("CELL"));
                actor.addInputConnectivtiy(mapper.getId());
                mapper.addOutputConnectivity(actor.getId());
            }
        }
        for (CassandraObject dataset : this.pipeLineManager.getDataSetList().getData()) {
            for (CassandraObject mapper : this.pipeLineManager.getMapperList().getData()) {
                if (((vtkMapper)mapper.getVtkObject()).GetInputAsDataSet() == null || !((vtkMapper)mapper.getVtkObject()).GetInputAsDataSet().equals(dataset.getVtkObject())) continue;
                this.connect((Cell)dataset.getMetaData().get("CELL"), (Cell)mapper.getMetaData().get("CELL"));
                mapper.addInputConnectivtiy(dataset.getId());
                dataset.addOutputConnectivity(mapper.getId());
            }
        }
        for (CassandraObject lookupTable : this.pipeLineManager.getLookupTableList().getData()) {
            for (CassandraObject mapper : this.pipeLineManager.getMapperList().getData()) {
                if (((vtkMapper)mapper.getVtkObject()).GetLookupTable() == null || !((vtkMapper)mapper.getVtkObject()).GetLookupTable().equals(lookupTable.getVtkObject())) continue;
                this.connect((Cell)lookupTable.getMetaData().get("CELL"), (Cell)mapper.getMetaData().get("CELL"));
                mapper.addOutputConnectivity(lookupTable.getId());
                lookupTable.addInputConnectivtiy(mapper.getId());
            }
            for (CassandraObject scalarBar : this.pipeLineManager.getScalarBarList().getData()) {
                if (((vtkScalarBarActor)scalarBar.getVtkObject()).GetLookupTable() == null || !((vtkScalarBarActor)scalarBar.getVtkObject()).GetLookupTable().equals(lookupTable.getVtkObject())) continue;
                this.connect((Cell)lookupTable.getMetaData().get("CELL"), (Cell)scalarBar.getMetaData().get("CELL"));
                lookupTable.addOutputConnectivity(scalarBar.getId());
                scalarBar.addInputConnectivtiy(lookupTable.getId());
            }
        }
        for (CassandraObject filter : this.pipeLineManager.getFilterList().getData()) {
            for (CassandraObject mapper : this.pipeLineManager.getMapperList().getData()) {
                for (Object vtkConnection : ((Filter)filter.getVtkObject()).getInputMapper()) {
                    if (!vtkConnection.equals(mapper.getVtkObject())) continue;
                    this.connect((Cell)filter.getMetaData().get("CELL"), (Cell)mapper.getMetaData().get("CELL"));
                    filter.addInputConnectivtiy(mapper.getId());
                    mapper.addOutputConnectivity(filter);
                }
                for (Object vtkConnection : ((Filter)filter.getVtkObject()).getOutputMapper()) {
                    if (!vtkConnection.equals(mapper.getVtkObject())) continue;
                    this.connect((Cell)filter.getMetaData().get("CELL"), (Cell)mapper.getMetaData().get("CELL"));
                    filter.addOutputConnectivity(mapper.getId());
                    mapper.addInputConnectivtiy(filter.getId());
                }
            }
            for (CassandraObject actor : this.pipeLineManager.getActorList().getData()) {
                for (Object vtkConnection : ((Filter)filter.getVtkObject()).getInputActor()) {
                    if (!vtkConnection.equals(actor.getVtkObject())) continue;
                    this.connect((Cell)filter.getMetaData().get("CELL"), (Cell)actor.getMetaData().get("CELL"));
                    filter.addInputConnectivtiy(actor.getId());
                    actor.addOutputConnectivity(filter.getId());
                }
                for (Object vtkConnection : ((Filter)filter.getVtkObject()).getOutputActor()) {
                    if (!vtkConnection.equals(actor.getVtkObject())) continue;
                    this.connect((Cell)filter.getMetaData().get("CELL"), (Cell)actor.getMetaData().get("CELL"));
                    filter.addOutputConnectivity(actor.getId());
                    actor.addInputConnectivtiy(filter.getId());
                }
            }
            for (CassandraObject dataset : this.pipeLineManager.getDataSetList().getData()) {
                for (Object vtkConnection : ((Filter)filter.getVtkObject()).getInputDataSet()) {
                    if (!vtkConnection.equals(dataset.getVtkObject())) continue;
                    this.connect((Cell)filter.getMetaData().get("CELL"), (Cell)dataset.getMetaData().get("CELL"));
                    filter.addInputConnectivtiy(dataset.getId());
                    dataset.addOutputConnectivity(filter.getId());
                }
                for (Object vtkConnection : ((Filter)filter.getVtkObject()).getOutputDataSet()) {
                    if (!vtkConnection.equals(dataset.getVtkObject())) continue;
                    this.connect((Cell)filter.getMetaData().get("CELL"), (Cell)dataset.getMetaData().get("CELL"));
                    filter.addOutputConnectivity(dataset.getId());
                    dataset.addInputConnectivtiy(filter.getId());
                }
            }
        }
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        VtkObjectCellAdapter cellAdapter = null;
        Object[] vtkObjectCellAdapterList = this.getCellList().toArray();
        for (int index = 0; index < vtkObjectCellAdapterList.length; ++index) {
            cellAdapter = (VtkObjectCellAdapter)vtkObjectCellAdapterList[index];
            if (this.pipeLineManager.getVtkObject(cellAdapter.getVtkObject().getId()) != null) continue;
            Iterator i = this.viewListenerList.iterator();
            while (i.hasNext()) {
                ((GraphViewListener)i.next()).removeCell(cellAdapter);
            }
            this.getCellList().remove(cellAdapter);
        }
        this.updateCell();
        this.updateConnection();
        this.reload();
    }

    @Override
    public void connectivityChange(CassandraObject vtkObject2) {
        this.updateConnection();
        this.reload();
    }

    public PipeLineManager getPipelineManager() {
        return this.pipeLineManager;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }
}

